/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ClassNotFoundSerialization;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.SerializableSupplier;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SerializationUtilsTest
extends AbstractLangTest {
    static final String CLASS_NOT_FOUND_MESSAGE = "ClassNotFoundSerialization.readObject fake exception";
    protected static final String SERIALIZE_IO_EXCEPTION_MESSAGE = "Anonymous OutputStream I/O exception";
    private String iString;
    private Integer iInteger;
    private HashMap<Object, Object> iMap;

    SerializationUtilsTest() {
    }

    @BeforeEach
    public void setUp() {
        this.iString = "foo";
        this.iInteger = 7;
        this.iMap = new HashMap();
        this.iMap.put("FOO", this.iString);
        this.iMap.put("BAR", this.iInteger);
    }

    @Test
    void testClone() {
        Serializable test = SerializationUtils.clone(this.iMap);
        Assertions.assertNotNull((Object)test);
        Assertions.assertInstanceOf(HashMap.class, (Object)test);
        Assertions.assertNotSame((Object)test, this.iMap);
        HashMap testMap = (HashMap)test;
        Assertions.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assertions.assertNotSame((Object)this.iString, testMap.get("FOO"));
        Assertions.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertNotSame((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    void testCloneNull() {
        Serializable test = SerializationUtils.clone(null);
        Assertions.assertNull((Object)test);
    }

    @Test
    void testCloneSerializableSupplier() {
        SerializableSupplier supplier = () -> "test";
        Assertions.assertEquals((Object)"test", supplier.get());
        SerializableSupplier clone = (SerializableSupplier)SerializationUtils.clone((Serializable)supplier);
        Assertions.assertEquals((Object)"test", clone.get());
    }

    @Test
    void testCloneUnserializable() {
        this.iMap.put(new Object(), new Object());
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.clone(this.iMap));
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new SerializationUtils());
        Constructor<?>[] cons = SerializationUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(SerializationUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(SerializationUtils.class.getModifiers()));
    }

    @Test
    void testDeserializeBytes() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(this.iMap);
            oos.flush();
        }
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        Assertions.assertNotNull((Object)test);
        Assertions.assertInstanceOf(HashMap.class, (Object)test);
        Assertions.assertNotSame((Object)test, this.iMap);
        HashMap testMap = (HashMap)test;
        Assertions.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assertions.assertNotSame((Object)this.iString, testMap.get("FOO"));
        Assertions.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertNotSame((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    void testDeserializeBytesBadStream() {
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((byte[])new byte[0]));
    }

    @Test
    void testDeserializeBytesNull() {
        LangAssertions.assertNullPointerException(() -> SerializationUtils.deserialize((byte[])null));
    }

    @Test
    void testDeserializeBytesOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(null);
            oos.flush();
        }
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        Assertions.assertNull((Object)test);
    }

    @Test
    void testDeserializeClassCastException() {
        String value = "Hello";
        byte[] serialized = SerializationUtils.serialize((Serializable)((Object)"Hello"));
        Assertions.assertEquals((Object)"Hello", (Object)SerializationUtils.deserialize((byte[])serialized));
        Assertions.assertThrows(ClassCastException.class, () -> {
            Integer i = (Integer)SerializationUtils.deserialize((byte[])serialized);
        });
    }

    @Test
    void testDeserializeStream() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(this.iMap);
            oos.flush();
        }
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        Assertions.assertNotNull((Object)test);
        Assertions.assertInstanceOf(HashMap.class, (Object)test);
        Assertions.assertNotSame((Object)test, this.iMap);
        HashMap testMap = (HashMap)test;
        Assertions.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assertions.assertNotSame((Object)this.iString, testMap.get("FOO"));
        Assertions.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertNotSame((Object)this.iInteger, testMap.get("BAR"));
        Assertions.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    void testDeserializeStreamBadStream() {
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((InputStream)new ByteArrayInputStream(new byte[0])));
    }

    @Test
    void testDeserializeStreamClassNotFound() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(new ClassNotFoundSerialization());
            oos.flush();
        }
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        SerializationException se = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((InputStream)inTest));
        Assertions.assertEquals((Object)"java.lang.ClassNotFoundException: ClassNotFoundSerialization.readObject fake exception", (Object)se.getMessage());
    }

    @Test
    void testDeserializeStreamNull() {
        LangAssertions.assertNullPointerException(() -> SerializationUtils.deserialize((InputStream)null));
    }

    @Test
    void testDeserializeStreamOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(null);
            oos.flush();
        }
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        Assertions.assertNull((Object)test);
    }

    @Test
    void testException() {
        Exception ex = new Exception();
        SerializationException serEx = new SerializationException();
        Assertions.assertSame(null, (Object)serEx.getMessage());
        Assertions.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException("Message");
        Assertions.assertSame((Object)"Message", (Object)serEx.getMessage());
        Assertions.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException((Throwable)ex);
        Assertions.assertEquals((Object)"java.lang.Exception", (Object)serEx.getMessage());
        Assertions.assertSame((Object)ex, (Object)serEx.getCause());
        serEx = new SerializationException("Message", (Throwable)ex);
        Assertions.assertSame((Object)"Message", (Object)serEx.getMessage());
        Assertions.assertSame((Object)ex, (Object)serEx.getCause());
    }

    @Test
    void testNegativeByteArray() {
        byte[] byteArray = new byte[]{-84, -19, 0, 5, 125, -19, 0, 5, 115, 114, -1, 97, 122, -48, -65};
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.deserialize((InputStream)new ByteArrayInputStream(byteArray)));
    }

    @Test
    void testPrimitiveTypeClassSerialization() {
        Class[] primitiveTypes;
        for (Class primitiveType : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Void.TYPE}) {
            Class clone = (Class)SerializationUtils.clone((Serializable)primitiveType);
            Assertions.assertEquals((Object)primitiveType, (Object)clone);
        }
    }

    @Test
    void testRoundtrip() {
        HashMap newMap = (HashMap)SerializationUtils.roundtrip(this.iMap);
        Assertions.assertEquals(this.iMap, (Object)newMap);
    }

    @Test
    void testSerializeBytes() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(this.iMap);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(this.iMap);
            oos.flush();
        }
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    void testSerializeBytesNull() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(null);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(null);
            oos.flush();
        }
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    void testSerializeBytesUnserializable() {
        this.iMap.put(new Object(), new Object());
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.serialize(this.iMap));
    }

    @Test
    void testSerializeIOException() {
        OutputStream streamTest = new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
                throw new IOException(SerializationUtilsTest.SERIALIZE_IO_EXCEPTION_MESSAGE);
            }
        };
        SerializationException e = (SerializationException)Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.serialize(this.iMap, (OutputStream)streamTest));
        Assertions.assertEquals((Object)"java.io.IOException: Anonymous OutputStream I/O exception", (Object)e.getMessage());
    }

    @Test
    void testSerializeStream() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(this.iMap);
            oos.flush();
        }
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    void testSerializeStreamNullNull() {
        LangAssertions.assertNullPointerException(() -> SerializationUtils.serialize(null, null));
    }

    @Test
    void testSerializeStreamNullObj() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(null, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(streamReal);){
            oos.writeObject(null);
            oos.flush();
        }
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        Assertions.assertEquals((int)testBytes.length, (int)realBytes.length);
        Assertions.assertArrayEquals((byte[])realBytes, (byte[])testBytes);
    }

    @Test
    void testSerializeStreamObjNull() {
        LangAssertions.assertNullPointerException(() -> SerializationUtils.serialize(this.iMap, null));
    }

    @Test
    void testSerializeStreamUnserializable() {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        this.iMap.put(new Object(), new Object());
        Assertions.assertThrows(SerializationException.class, () -> SerializationUtils.serialize(this.iMap, (OutputStream)streamTest));
    }
}

