/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayUtilsSetTest
extends AbstractLangTest {
    ArrayUtilsSetTest() {
    }

    @Test
    void testSetAll_IntFunction() {
        IntFunction nullIntFunction = null;
        Assertions.assertNull((Object)ArrayUtils.setAll(null, nullIntFunction));
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.setAll(null, nullIntFunction));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])ArrayUtils.setAll((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, nullIntFunction));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])ArrayUtils.setAll((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, nullIntFunction));
        Object[] array = new Integer[10];
        Integer[] array2 = (Integer[])ArrayUtils.setAll((Object[])array, Integer::valueOf);
        Assertions.assertSame((Object)array, (Object)array2);
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)array[i]));
        }
    }

    @Test
    void testSetAll_Supplier() {
        Supplier nullSupplier = null;
        Assertions.assertNull((Object)ArrayUtils.setAll(null, nullSupplier));
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.setAll(null, nullSupplier));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])ArrayUtils.setAll((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, nullSupplier));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])ArrayUtils.setAll((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, nullSupplier));
        Object[] array = new String[10];
        String[] array2 = (String[])ArrayUtils.setAll((Object[])array, () -> "");
        Assertions.assertSame((Object)array, (Object)array2);
        for (Object s : array) {
            Assertions.assertEquals((Object)"", (Object)s);
        }
    }
}

