/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.function.Suppliers;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.text.StrBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ObjectUtilsTest
extends AbstractLangTest {
    private static final Supplier<?> NULL_SUPPLIER = null;
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String[] NON_EMPTY_ARRAY = new String[]{"foo", "bar"};
    private static final List<String> NON_EMPTY_LIST = Arrays.asList(NON_EMPTY_ARRAY);
    private static final Set<String> NON_EMPTY_SET = new HashSet<String>(NON_EMPTY_LIST);
    private static final Map<String, String> NON_EMPTY_MAP = new HashMap<String, String>();

    ObjectUtilsTest() {
    }

    @Test
    void testAllNotNull() {
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])null));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{null, null, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{null, FOO, BAR}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO, BAR, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO, BAR, null, FOO, BAR}));
        Assertions.assertTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[0]));
        Assertions.assertTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO}));
        Assertions.assertTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{FOO, BAR, 1, Boolean.TRUE, new Object(), new Object[0]}));
    }

    @Test
    void testAllNull() {
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])new Object[0]));
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])new Object[]{null}));
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])null));
        Assertions.assertTrue((boolean)ObjectUtils.allNull((Object[])new Object[]{null, null, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNull((Object[])new Object[]{FOO}));
        Assertions.assertFalse((boolean)ObjectUtils.allNull((Object[])new Object[]{null, FOO, null}));
        Assertions.assertFalse((boolean)ObjectUtils.allNull((Object[])new Object[]{null, null, null, null, FOO, BAR}));
    }

    @Test
    void testAnyNotNull() {
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])new Object[0]));
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null}));
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])null));
        Assertions.assertFalse((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null, null, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{FOO}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null, FOO, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNotNull((Object[])new Object[]{null, null, null, null, FOO, BAR}));
    }

    @Test
    void testAnyNull() {
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{null, null, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{null, FOO, BAR}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO, BAR, null}));
        Assertions.assertTrue((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO, BAR, null, FOO, BAR}));
        Assertions.assertFalse((boolean)ObjectUtils.anyNull((Object[])new Object[0]));
        Assertions.assertFalse((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO}));
        Assertions.assertFalse((boolean)ObjectUtils.anyNull((Object[])new Object[]{FOO, BAR, 1, Boolean.TRUE, new Object(), new Object[0]}));
    }

    @Test
    void testArray() {
        Assertions.assertFalse((boolean)ObjectUtils.isArray(null));
        Assertions.assertFalse((boolean)ObjectUtils.isArray((Object)""));
        Assertions.assertFalse((boolean)ObjectUtils.isArray((Object)"abg"));
        Assertions.assertFalse((boolean)ObjectUtils.isArray((Object)123));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)NON_EMPTY_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)new int[]{1, 2, 3}));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_BYTE_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_CHAR_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_CLASS_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_FIELD_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_FLOAT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_INT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_LONG_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_METHOD_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_SHORT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_STRING_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_THROWABLE_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isArray((Object)ArrayUtils.EMPTY_TYPE_ARRAY));
    }

    @Test
    void testCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.clone((Object)string);
        Assertions.assertEquals((Object)"apache", (Object)stringClone.get());
    }

    @Test
    void testCloneOfNotCloneable() {
        String string = "apache";
        Assertions.assertNull((Object)ObjectUtils.clone((Object)"apache"));
    }

    @Test
    void testCloneOfPrimitiveArray() {
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])((int[])ObjectUtils.clone((Object)new int[]{1})));
    }

    @Test
    void testCloneOfStringArray() {
        Assertions.assertTrue((boolean)Arrays.deepEquals(new String[]{"string"}, (Object[])ObjectUtils.clone((Object)new String[]{"string"})));
    }

    @Test
    void testCloneOfUncloneable() {
        UncloneableString string = new UncloneableString("apache");
        CloneFailedException e = (CloneFailedException)Assertions.assertThrows(CloneFailedException.class, () -> ObjectUtils.clone((Object)string));
        Assertions.assertNotNull((Object)e);
        Assertions.assertNotNull((Object)e.getCause());
        Assertions.assertEquals(NoSuchMethodException.class, e.getCause().getClass());
    }

    @Test
    void testComparatorMedian() {
        CharSequenceComparator cmp = new CharSequenceComparator();
        NonComparableCharSequence foo = new NonComparableCharSequence(FOO);
        NonComparableCharSequence bar = new NonComparableCharSequence(BAR);
        NonComparableCharSequence baz = new NonComparableCharSequence("baz");
        NonComparableCharSequence blah = new NonComparableCharSequence("blah");
        NonComparableCharSequence wah = new NonComparableCharSequence("wah");
        Assertions.assertSame((Object)foo, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo}));
        Assertions.assertSame((Object)bar, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar}));
        Assertions.assertSame((Object)baz, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz}));
        Assertions.assertSame((Object)baz, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz, blah}));
        Assertions.assertSame((Object)blah, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz, blah, wah}));
    }

    @Test
    void testComparatorMedian_emptyItems() {
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.median((Comparator)new CharSequenceComparator(), (Object[])new CharSequence[0]));
    }

    @Test
    void testComparatorMedian_nullComparator() {
        LangAssertions.assertNullPointerException(() -> ObjectUtils.median((Comparator)null, (Object[])new CharSequence[]{new NonComparableCharSequence(FOO)}));
    }

    @Test
    void testComparatorMedian_nullItems() {
        LangAssertions.assertNullPointerException(() -> ObjectUtils.median((Comparator)new CharSequenceComparator(), (Object[])null));
    }

    @Test
    void testCompare() {
        Integer one = 1;
        Integer two = 2;
        Comparable nullValue = null;
        Assertions.assertEquals((int)0, (int)ObjectUtils.compare(nullValue, nullValue), (String)"Null Null false");
        Assertions.assertEquals((int)0, (int)ObjectUtils.compare(nullValue, nullValue, (boolean)true), (String)"Null Null true");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare(nullValue, (Comparable)one), (String)"Null one false");
        Assertions.assertEquals((int)1, (int)ObjectUtils.compare(nullValue, (Comparable)one, (boolean)true), (String)"Null one true");
        Assertions.assertEquals((int)1, (int)ObjectUtils.compare((Comparable)one, nullValue), (String)"one Null false");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare((Comparable)one, nullValue, (boolean)true), (String)"one Null true");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare((Comparable)one, (Comparable)two), (String)"one two false");
        Assertions.assertEquals((int)-1, (int)ObjectUtils.compare((Comparable)one, (Comparable)two, (boolean)true), (String)"one two true");
    }

    @Test
    void testConstMethods() {
        Assertions.assertTrue((boolean)ObjectUtils.CONST((boolean)true), (String)"CONST(boolean)");
        Assertions.assertEquals((byte)3, (byte)ObjectUtils.CONST((byte)3), (String)"CONST(byte)");
        Assertions.assertEquals((char)'\u0003', (char)ObjectUtils.CONST((char)'\u0003'), (String)"CONST(char)");
        Assertions.assertEquals((short)3, (short)ObjectUtils.CONST((short)3), (String)"CONST(short)");
        Assertions.assertEquals((int)3, (int)ObjectUtils.CONST((int)3), (String)"CONST(int)");
        Assertions.assertEquals((long)3L, (long)ObjectUtils.CONST((long)3L), (String)"CONST(long)");
        Assertions.assertEquals((float)3.0f, (float)ObjectUtils.CONST((float)3.0f), (String)"CONST(float)");
        Assertions.assertEquals((double)3.0, (double)ObjectUtils.CONST((double)3.0), (String)"CONST(double)");
        Assertions.assertEquals((Object)"abc", (Object)ObjectUtils.CONST((Object)"abc"), (String)"CONST(Object)");
        boolean MAGIC_FLAG = ObjectUtils.CONST((boolean)true);
        byte MAGIC_BYTE1 = ObjectUtils.CONST((byte)127);
        byte MAGIC_BYTE2 = ObjectUtils.CONST_BYTE((int)127);
        char MAGIC_CHAR = ObjectUtils.CONST((char)'a');
        short MAGIC_SHORT1 = ObjectUtils.CONST((short)123);
        short MAGIC_SHORT2 = ObjectUtils.CONST_SHORT((int)127);
        int MAGIC_INT = ObjectUtils.CONST((int)123);
        long MAGIC_LONG1 = ObjectUtils.CONST((long)123L);
        long MAGIC_LONG2 = ObjectUtils.CONST((int)3);
        float MAGIC_FLOAT = ObjectUtils.CONST((float)1.0f);
        double MAGIC_DOUBLE = ObjectUtils.CONST((double)1.0);
        String MAGIC_STRING = (String)ObjectUtils.CONST((Object)"abc");
        Assertions.assertTrue((boolean)MAGIC_FLAG);
        Assertions.assertEquals((int)127, (int)MAGIC_BYTE1);
        Assertions.assertEquals((int)127, (int)MAGIC_BYTE2);
        Assertions.assertEquals((char)'a', (char)MAGIC_CHAR);
        Assertions.assertEquals((int)123, (int)MAGIC_SHORT1);
        Assertions.assertEquals((int)127, (int)MAGIC_SHORT2);
        Assertions.assertEquals((int)123, (int)MAGIC_INT);
        Assertions.assertEquals((long)123L, (long)MAGIC_LONG1);
        Assertions.assertEquals((long)3L, (long)MAGIC_LONG2);
        Assertions.assertEquals((float)1.0f, (float)MAGIC_FLOAT);
        Assertions.assertEquals((double)1.0, (double)MAGIC_DOUBLE);
        Assertions.assertEquals((Object)"abc", (Object)MAGIC_STRING);
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.CONST_BYTE((int)-129), "CONST_BYTE(-129): IllegalArgumentException should have been thrown.");
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.CONST_BYTE((int)128), "CONST_BYTE(128): IllegalArgumentException should have been thrown.");
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.CONST_SHORT((int)-32769), "CONST_SHORT(-32769): IllegalArgumentException should have been thrown.");
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.CONST_BYTE((int)32768), "CONST_SHORT(32768): IllegalArgumentException should have been thrown.");
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new ObjectUtils());
        Constructor<?>[] cons = ObjectUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ObjectUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ObjectUtils.class.getModifiers()));
    }

    @Test
    void testDefaultIfNull() {
        String o = FOO;
        String dflt = BAR;
        Assertions.assertSame((Object)dflt, (Object)ObjectUtils.defaultIfNull(null, (Object)dflt), (String)"dflt was not returned when o was null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.defaultIfNull((Object)o, (Object)dflt), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)dflt, (Object)ObjectUtils.getIfNull(null, () -> dflt), (String)"dflt was not returned when o was null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)o, () -> dflt), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)FOO, () -> dflt), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)FOO, () -> dflt), (String)"dflt was returned when o was not null");
        MutableInt callsCounter = new MutableInt(0);
        Supplier<Object> countingDefaultSupplier = () -> {
            callsCounter.increment();
            return dflt;
        };
        ObjectUtils.getIfNull((Object)o, countingDefaultSupplier);
        Assertions.assertEquals((Object)0, (Object)callsCounter.get());
        ObjectUtils.getIfNull(null, countingDefaultSupplier);
        Assertions.assertEquals((Object)1, (Object)callsCounter.get());
    }

    @Test
    void testEquals() {
        Assertions.assertTrue((boolean)ObjectUtils.equals(null, null), (String)"ObjectUtils.equals(null, null) returned false");
        Assertions.assertFalse((boolean)ObjectUtils.equals((Object)FOO, null), (String)"ObjectUtils.equals(\"foo\", null) returned true");
        Assertions.assertFalse((boolean)ObjectUtils.equals(null, (Object)BAR), (String)"ObjectUtils.equals(null, \"bar\") returned true");
        Assertions.assertFalse((boolean)ObjectUtils.equals((Object)FOO, (Object)BAR), (String)"ObjectUtils.equals(\"foo\", \"bar\") returned true");
        Assertions.assertTrue((boolean)ObjectUtils.equals((Object)FOO, (Object)FOO), (String)"ObjectUtils.equals(\"foo\", \"foo\") returned false");
    }

    @Test
    void testFirstNonNull() {
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.firstNonNull((Object[])new String[]{null, ""}));
        String firstNonNullGenerics = (String)ObjectUtils.firstNonNull((Object[])new String[]{null, null, "123", "456"});
        Assertions.assertEquals((Object)"123", (Object)firstNonNullGenerics);
        Assertions.assertEquals((Object)"123", (Object)ObjectUtils.firstNonNull((Object[])new String[]{"123", null, "456", null}));
        Assertions.assertSame((Object)Boolean.TRUE, (Object)ObjectUtils.firstNonNull((Object[])new Boolean[]{Boolean.TRUE}));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[0]));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null, null}));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null}));
        Assertions.assertNull((Object)ObjectUtils.firstNonNull((Object[])null));
    }

    @Test
    void testGetClass() {
        String[] newArray = ArrayUtils.EMPTY_STRING_ARRAY;
        Class cls = ObjectUtils.getClass((Object)newArray);
        Assertions.assertEquals(String[].class, (Object)cls);
        Assertions.assertNull((Object)ObjectUtils.getClass(null));
    }

    @Test
    void testGetFirstNonNull() {
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{null, () -> ""}));
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{Suppliers.nul(), () -> ""}));
        Assertions.assertEquals((Object)"1", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{Suppliers.nul(), () -> "1", () -> "2", Suppliers.nul()}));
        Assertions.assertEquals((Object)"123", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{() -> "123", Suppliers.nul(), () -> "456"}));
        Assertions.assertEquals((Object)"123", (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{Suppliers.nul(), () -> "123", () -> (String)Assertions.fail((String)"Supplier after first non-null value should not be evaluated")}));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{null, Suppliers.nul()}));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[0]));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{null}));
        Assertions.assertNull((Object)ObjectUtils.getFirstNonNull((Supplier[])null));
        Assertions.assertEquals((int)1, (Integer)((Integer)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{Suppliers.nul(), () -> 1})));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ObjectUtils.getFirstNonNull((Supplier[])new Supplier[]{Suppliers.nul(), () -> Boolean.TRUE}));
    }

    @Test
    void testGetIfNullObject() {
        String o = FOO;
        String defaultObject = BAR;
        Assertions.assertNull((Object)ObjectUtils.getIfNull(null, null));
        Assertions.assertSame((Object)defaultObject, (Object)ObjectUtils.getIfNull(null, (Object)defaultObject), (String)"dflt was not returned when o was null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)o, (Object)defaultObject), (String)"dflt was returned when o was not null");
    }

    @Test
    void testGetIfNullSupplier() {
        String o = FOO;
        String defaultObject = BAR;
        Assertions.assertNull((Object)ObjectUtils.getIfNull(null, (Supplier)null));
        Assertions.assertSame((Object)defaultObject, (Object)ObjectUtils.getIfNull(null, () -> defaultObject), (String)"dflt was not returned when o was null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)o, () -> defaultObject), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)FOO, () -> defaultObject), (String)"dflt was returned when o was not null");
        Assertions.assertSame((Object)o, (Object)ObjectUtils.getIfNull((Object)FOO, () -> defaultObject), (String)"dflt was returned when o was not null");
        MutableInt callsCounter = new MutableInt(0);
        Supplier<Object> countingDefaultSupplier = () -> {
            callsCounter.increment();
            return defaultObject;
        };
        ObjectUtils.getIfNull((Object)o, countingDefaultSupplier);
        Assertions.assertEquals((Object)0, (Object)callsCounter.get());
        ObjectUtils.getIfNull(null, countingDefaultSupplier);
        Assertions.assertEquals((Object)1, (Object)callsCounter.get());
    }

    @Test
    void testHashCode() {
        Assertions.assertEquals((int)0, (int)ObjectUtils.hashCode(null));
        Assertions.assertEquals((int)"a".hashCode(), (int)ObjectUtils.hashCode((Object)"a"));
    }

    @Test
    void testHashCodeHex() {
        Integer i = 90;
        Assertions.assertEquals((Object)Integer.toHexString(Objects.hashCode(i)), (Object)ObjectUtils.hashCodeHex((Object)i));
        Integer zero = 0;
        Assertions.assertEquals((Object)Integer.toHexString(Objects.hashCode(zero)), (Object)ObjectUtils.hashCodeHex((Object)zero));
        Assertions.assertEquals((Object)Integer.toHexString(Objects.hashCode(null)), (Object)ObjectUtils.hashCodeHex(null));
    }

    @Test
    void testHashCodeMulti_multiple_emptyArray() {
        Object[] array = new Object[]{};
        Assertions.assertEquals((int)1, (int)ObjectUtils.hashCodeMulti((Object[])array));
    }

    @Test
    void testHashCodeMulti_multiple_likeList() {
        ArrayList list0 = new ArrayList(Collections.emptyList());
        Assertions.assertEquals((int)list0.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[0]));
        ArrayList<String> list1 = new ArrayList<String>(Collections.singletonList("a"));
        Assertions.assertEquals((int)list1.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a"}));
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList("a", "b"));
        Assertions.assertEquals((int)list2.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b"}));
        ArrayList<String> list3 = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        Assertions.assertEquals((int)list3.hashCode(), (int)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b", "c"}));
    }

    @Test
    void testHashCodeMulti_multiple_nullArray() {
        Object[] array = null;
        Assertions.assertEquals((int)1, (int)ObjectUtils.hashCodeMulti(array));
    }

    @Test
    void testIdentityHashCodeHex() {
        Integer i = 90;
        Assertions.assertEquals((Object)Integer.toHexString(System.identityHashCode(i)), (Object)ObjectUtils.identityHashCodeHex((Object)i));
        Integer zero = 0;
        Assertions.assertEquals((Object)Integer.toHexString(System.identityHashCode(zero)), (Object)ObjectUtils.identityHashCodeHex((Object)zero));
        Assertions.assertEquals((Object)Integer.toHexString(System.identityHashCode(null)), (Object)ObjectUtils.identityHashCodeHex(null));
    }

    @Test
    void testIdentityToStringAppendable() throws IOException {
        Integer i = 121;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuilder appendable = new StringBuilder();
        ObjectUtils.identityToString((Appendable)appendable, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)((Object)appendable).toString());
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((Appendable)null, (Object)"tmp"));
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((Appendable)new StringBuilder(), null));
    }

    @Test
    void testIdentityToStringInteger() {
        Integer i = 90;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        Assertions.assertEquals((Object)expected, (Object)ObjectUtils.identityToString((Object)i));
    }

    @Test
    void testIdentityToStringObjectNull() {
        Assertions.assertNull((Object)ObjectUtils.identityToString(null));
    }

    @Test
    void testIdentityToStringStrBuilder() {
        Integer i = 102;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StrBuilder builder = new StrBuilder();
        ObjectUtils.identityToString((StrBuilder)builder, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)builder.toString());
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((StrBuilder)null, (Object)"tmp"));
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((StrBuilder)new StrBuilder(), null));
    }

    @Test
    void testIdentityToStringString() {
        Assertions.assertEquals((Object)("java.lang.String@" + Integer.toHexString(System.identityHashCode(FOO))), (Object)ObjectUtils.identityToString((Object)FOO));
    }

    @Test
    void testIdentityToStringStringBuffer() {
        Integer i = 45;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuffer buffer = new StringBuffer();
        ObjectUtils.identityToString((StringBuffer)buffer, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)buffer.toString());
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((StringBuffer)null, (Object)"tmp"));
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((StringBuffer)new StringBuffer(), null));
    }

    @Test
    void testIdentityToStringStringBuilder() {
        Integer i = 90;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuilder builder = new StringBuilder();
        ObjectUtils.identityToString((StringBuilder)builder, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)builder.toString());
    }

    @Test
    void testIdentityToStringStringBuilderInUse() {
        Integer i = 90;
        String expected = "ABC = java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        StringBuilder builder = new StringBuilder("ABC = ");
        ObjectUtils.identityToString((StringBuilder)builder, (Object)i);
        Assertions.assertEquals((Object)expected, (Object)builder.toString());
    }

    @Test
    public void testIdentityToStringStringBuilderNullStringBuilder() {
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((StringBuilder)null, (Object)"tmp"));
    }

    @Test
    void testIdentityToStringStringBuilderNullValue() {
        LangAssertions.assertNullPointerException(() -> ObjectUtils.identityToString((StringBuilder)new StringBuilder(), null));
    }

    @Test
    void testIsEmpty() {
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(null));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty((Object)""));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty((Object)new int[0]));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Collections.emptyList()));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Collections.emptySet()));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Collections.emptyMap()));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Optional.empty()));
        Assertions.assertTrue((boolean)ObjectUtils.isEmpty(Optional.ofNullable(null)));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty((Object)"  "));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty((Object)"ab"));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty((Object)NON_EMPTY_ARRAY));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(NON_EMPTY_LIST));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(NON_EMPTY_SET));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(NON_EMPTY_MAP));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(Optional.of(new Object())));
        Assertions.assertFalse((boolean)ObjectUtils.isEmpty(Optional.ofNullable(new Object())));
    }

    @Test
    void testIsNotEmpty() {
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(null));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty((Object)""));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty((Object)new int[0]));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Collections.emptyList()));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Collections.emptySet()));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Collections.emptyMap()));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Optional.empty()));
        Assertions.assertFalse((boolean)ObjectUtils.isNotEmpty(Optional.ofNullable(null)));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty((Object)"  "));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty((Object)"ab"));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty((Object)NON_EMPTY_ARRAY));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(NON_EMPTY_LIST));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(NON_EMPTY_SET));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(NON_EMPTY_MAP));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(Optional.of(new Object())));
        Assertions.assertTrue((boolean)ObjectUtils.isNotEmpty(Optional.ofNullable(new Object())));
    }

    @Test
    void testMax() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullArray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        Assertions.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        Assertions.assertNull((Object)ObjectUtils.max((Comparable[])new String[]{null}));
        Assertions.assertNull((Object)ObjectUtils.max(nullArray));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        Assertions.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, minComparable, null, nonNullComparable1}));
        Assertions.assertNull((Object)ObjectUtils.max((Comparable[])new Comparable[]{null, null}));
    }

    @Test
    void testMedian() {
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.median((Comparable[])new String[]{FOO}));
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR}));
        Assertions.assertEquals((Object)"baz", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz"}));
        Assertions.assertEquals((Object)"baz", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz", "blah"}));
        Assertions.assertEquals((Object)"blah", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz", "blah", "wah"}));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)ObjectUtils.median((Comparable[])new Integer[]{1, 5, 10})));
        Assertions.assertEquals((Integer)7, (Integer)((Integer)ObjectUtils.median((Comparable[])new Integer[]{5, 6, 7, 8, 9})));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)ObjectUtils.median((Comparable[])new Integer[]{5, 6, 7, 8})));
    }

    @Test
    void testMedian_emptyItems() {
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.median((Comparable[])new String[0]));
    }

    @Test
    void testMedian_nullItems() {
        LangAssertions.assertNullPointerException(() -> ObjectUtils.median((Comparable[])((String[])null)));
    }

    @Test
    void testMin() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullArray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        Assertions.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        Assertions.assertNull((Object)ObjectUtils.min((Comparable[])new String[]{null}));
        Assertions.assertNull((Object)ObjectUtils.min(nullArray));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null}));
        Assertions.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        Assertions.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        Assertions.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        Assertions.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        Assertions.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null, minComparable}));
        Assertions.assertNull((Object)ObjectUtils.min((Comparable[])new Comparable[]{null, null}));
    }

    @Test
    void testMode() {
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])null));
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])new Object[0]));
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz"}));
        Assertions.assertNull((Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz", FOO, BAR}));
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz", FOO}));
        Assertions.assertEquals((Object)9, (Object)ObjectUtils.mode((Object[])new Serializable[]{FOO, BAR, "baz", Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(9)}));
    }

    @Test
    void testNotEqual() {
        Assertions.assertFalse((boolean)ObjectUtils.notEqual(null, null), (String)"ObjectUtils.notEqual(null, null) returned false");
        Assertions.assertTrue((boolean)ObjectUtils.notEqual((Object)FOO, null), (String)"ObjectUtils.notEqual(\"foo\", null) returned true");
        Assertions.assertTrue((boolean)ObjectUtils.notEqual(null, (Object)BAR), (String)"ObjectUtils.notEqual(null, \"bar\") returned true");
        Assertions.assertTrue((boolean)ObjectUtils.notEqual((Object)FOO, (Object)BAR), (String)"ObjectUtils.notEqual(\"foo\", \"bar\") returned true");
        Assertions.assertFalse((boolean)ObjectUtils.notEqual((Object)FOO, (Object)FOO), (String)"ObjectUtils.notEqual(\"foo\", \"foo\") returned false");
    }

    @Test
    void testNull() {
        Assertions.assertNotNull((Object)ObjectUtils.NULL);
        Assertions.assertInstanceOf(ObjectUtils.Null.class, (Object)ObjectUtils.NULL);
        Assertions.assertSame((Object)ObjectUtils.NULL, (Object)SerializationUtils.clone((Serializable)ObjectUtils.NULL));
    }

    @Test
    void testPossibleCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.cloneIfPossible((Object)string);
        Assertions.assertEquals((Object)"apache", (Object)stringClone.get());
    }

    @Test
    void testPossibleCloneOfNotCloneable() {
        String string = "apache";
        Assertions.assertSame((Object)"apache", (Object)ObjectUtils.cloneIfPossible((Object)"apache"));
    }

    @Test
    void testPossibleCloneOfUncloneable() {
        UncloneableString string = new UncloneableString("apache");
        CloneFailedException e = (CloneFailedException)Assertions.assertThrows(CloneFailedException.class, () -> ObjectUtils.cloneIfPossible((Object)string));
        Assertions.assertNotNull((Object)e);
        Assertions.assertNotNull((Object)e.getCause());
        Assertions.assertEquals(NoSuchMethodException.class, e.getCause().getClass());
    }

    @Test
    void testRequireNonEmpty() {
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.requireNonEmpty((Object)FOO));
        Assertions.assertEquals((Object)FOO, (Object)ObjectUtils.requireNonEmpty((Object)FOO, (String)FOO));
        LangAssertions.assertNullPointerException(() -> ObjectUtils.requireNonEmpty(null));
        LangAssertions.assertNullPointerException(() -> ObjectUtils.requireNonEmpty(null, (String)FOO));
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.requireNonEmpty((Object)""));
        LangAssertions.assertIllegalArgumentException(() -> ObjectUtils.requireNonEmpty((Object)"", (String)FOO));
    }

    @Test
    void testToString_Object() {
        Assertions.assertEquals((Object)"", (Object)ObjectUtils.toString(null));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE));
    }

    @Test
    void testToString_Object_String() {
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.toString(null, (String)BAR));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE, (String)BAR));
    }

    @Test
    void testToString_String_Supplier() {
        Assertions.assertNull((Object)ObjectUtils.toString(null, (Supplier)null));
        Assertions.assertNull((Object)ObjectUtils.toString(null, (Supplier)Suppliers.nul()));
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.toString(null, () -> BAR));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE, () -> BAR));
    }

    @Test
    void testToString_Supplier_Supplier() {
        Assertions.assertNull((Object)ObjectUtils.toString(NULL_SUPPLIER, (Supplier)null));
        Assertions.assertNull((Object)ObjectUtils.toString((Supplier)Suppliers.nul(), (Supplier)null));
        Assertions.assertNull((Object)ObjectUtils.toString(NULL_SUPPLIER, (Supplier)Suppliers.nul()));
        Assertions.assertNull((Object)ObjectUtils.toString((Supplier)Suppliers.nul(), (Supplier)Suppliers.nul()));
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.toString(NULL_SUPPLIER, () -> BAR));
        Assertions.assertEquals((Object)BAR, (Object)ObjectUtils.toString((Supplier)Suppliers.nul(), () -> BAR));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString(() -> Boolean.TRUE, () -> BAR));
    }

    @Test
    void testWaitDuration() {
        Assertions.assertThrows(IllegalMonitorStateException.class, () -> ObjectUtils.wait((Object)new Object(), (Duration)Duration.ZERO));
    }

    static {
        NON_EMPTY_MAP.put(FOO, BAR);
    }

    static final class CloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        CloneableString(String s) {
            super((Object)s);
        }

        public CloneableString clone() throws CloneNotSupportedException {
            return (CloneableString)super.clone();
        }
    }

    static final class UncloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        UncloneableString(String s) {
            super((Object)s);
        }
    }

    static final class CharSequenceComparator
    implements Comparator<CharSequence> {
        CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    static final class NonComparableCharSequence
    implements CharSequence {
        final String value;

        NonComparableCharSequence(String value) {
            Validate.notNull((Object)value);
            this.value = value;
        }

        @Override
        public char charAt(int arg0) {
            return this.value.charAt(arg0);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public CharSequence subSequence(int arg0, int arg1) {
            return this.value.subSequence(arg0, arg1);
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

