/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.CircuitBreakingException;
import org.apache.commons.lang3.exception.AbstractExceptionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CircuitBreakingExceptionTest
extends AbstractExceptionTest {
    CircuitBreakingExceptionTest() {
    }

    @Test
    void testThrowingEmptyException() {
        Assertions.assertThrows(CircuitBreakingException.class, () -> {
            throw new CircuitBreakingException();
        });
    }

    @Test
    void testThrowingExceptionWithCause() {
        Assertions.assertThrows(CircuitBreakingException.class, () -> {
            throw new CircuitBreakingException((Throwable)this.generateCause());
        });
    }

    @Test
    void testThrowingExceptionWithMessage() {
        Assertions.assertThrows(CircuitBreakingException.class, () -> {
            throw new CircuitBreakingException("Exception message");
        });
    }

    @Test
    void testThrowingInformativeException() {
        Assertions.assertThrows(CircuitBreakingException.class, () -> {
            throw new CircuitBreakingException("Exception message", (Throwable)this.generateCause());
        });
    }

    @Test
    void testWithCauseAndMessage() {
        CircuitBreakingException exception = new CircuitBreakingException("Exception message", (Throwable)this.generateCause());
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"Exception message", (Object)exception.getMessage(), (String)"Wrong exception message");
        Throwable cause = exception.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Cause message", (Object)cause.getMessage(), (String)"Wrong cause message");
    }

    @Test
    void testWithoutCause() {
        CircuitBreakingException exception = new CircuitBreakingException("Exception message");
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"Exception message", (Object)exception.getMessage(), (String)"Wrong exception message");
        Throwable cause = exception.getCause();
        Assertions.assertNull((Object)cause);
    }

    @Test
    void testWithoutMessage() {
        CircuitBreakingException exception = new CircuitBreakingException((Throwable)this.generateCause());
        Assertions.assertNotNull((Object)exception);
        Assertions.assertNotNull((Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertEquals((Object)"Cause message", (Object)cause.getMessage(), (String)"Wrong cause message");
    }
}

