/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import org.apache.commons.statistics.distribution.HypergeometricDistribution;

class Hypergeom {
    private static final double HALF = 0.5;
    private final int lowerBound;
    private final int upperBound;
    private final double[] prob;
    private final int m;
    private final double midCDF;
    private final int m1;
    private final int m2;

    Hypergeom(int populationSize, int numberOfSuccesses, int sampleSize) {
        double p1;
        int x;
        HypergeometricDistribution dist = HypergeometricDistribution.of((int)populationSize, (int)numberOfSuccesses, (int)sampleSize);
        this.lowerBound = dist.getSupportLowerBound();
        this.upperBound = dist.getSupportUpperBound();
        this.prob = new double[this.upperBound + 1];
        for (x = this.lowerBound; x <= this.upperBound; ++x) {
            this.prob[x] = dist.probability(x);
        }
        x = this.lowerBound;
        double p0 = 0.0;
        for (p1 = this.prob[x]; p1 < 0.5; p1 += this.prob[++x]) {
            p0 = p1;
        }
        if (p1 - 0.5 >= 0.5 - p0) {
            --x;
            p1 = p0;
        }
        this.m = x;
        this.midCDF = p1;
        double v = ((double)numberOfSuccesses + 1.0) * ((double)sampleSize + 1.0) / ((double)populationSize + 2.0);
        this.m1 = (int)Math.ceil(v) - 1;
        this.m2 = (int)Math.floor(v);
    }

    int getSupportLowerBound() {
        return this.lowerBound;
    }

    int getSupportUpperBound() {
        return this.upperBound;
    }

    int getLowerMode() {
        return this.m1;
    }

    int getUpperMode() {
        return this.m2;
    }

    double pmf(int x) {
        return this.prob[x];
    }

    double cdf(int x) {
        if (x < this.lowerBound) {
            return 0.0;
        }
        if (x >= this.upperBound) {
            return 1.0;
        }
        if (x < this.m) {
            return this.innerCumulativeProbability(this.lowerBound, x);
        }
        if (x > this.m) {
            return 1.0 - this.innerCumulativeProbability(this.upperBound, x + 1);
        }
        return this.midCDF;
    }

    double sf(int x) {
        if (x < this.lowerBound) {
            return 1.0;
        }
        if (x >= this.upperBound) {
            return 0.0;
        }
        if (x < this.m) {
            return 1.0 - this.innerCumulativeProbability(this.lowerBound, x);
        }
        if (x > this.m) {
            return this.innerCumulativeProbability(this.upperBound, x + 1);
        }
        return 1.0 - this.midCDF;
    }

    private double innerCumulativeProbability(int x0, int x1) {
        int x = x0;
        double ret = this.prob[x];
        if (x0 < x1) {
            while (x != x1) {
                ret += this.prob[++x];
            }
        } else {
            while (x != x1) {
                ret += this.prob[--x];
            }
        }
        return ret;
    }
}

