/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.function.IntToDoubleFunction;

final class Searches {
    private static final int BINARY_SEARCH = 8;

    private Searches() {
    }

    static int searchDescending(int a, int b, double x, IntToDoubleFunction value) {
        int offset = a + b;
        return offset - Searches.searchAscending(a, b, x, i -> value.applyAsDouble(offset - i));
    }

    static int searchAscending(int a, int b, double x, IntToDoubleFunction value) {
        int i;
        if (b - a > 8) {
            if (value.applyAsDouble(a) > x) {
                return a - 1;
            }
            if (value.applyAsDouble(b) <= x) {
                return b;
            }
            int lo = a;
            int hi = b;
            while (lo + 1 < hi) {
                int mid = lo + hi >>> 1;
                if (value.applyAsDouble(mid) <= x) {
                    lo = mid;
                    continue;
                }
                hi = mid;
            }
            return lo;
        }
        for (i = a - 1; i < b && value.applyAsDouble(i + 1) <= x; ++i) {
        }
        return i;
    }
}

