/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.util.Messages;
import org.junit.jupiter.api.Assertions;

public abstract class VfsTestUtils {
    public static final String TEST_BASE_DIR = "test.basedir";
    private static File baseDir;
    private static final Pattern URL_PATTERN;
    private static final Pattern PASSWORD_PATTERN;

    public static void assertSameMessage(String code, Object param, Throwable throwable) {
        VfsTestUtils.assertSameMessage(code, new Object[]{param}, throwable);
    }

    private static void assertSameMessage(String code, Object[] params, Throwable throwable) {
        Object[] parmArray = params;
        if (throwable instanceof FileSystemException) {
            FileSystemException fse = (FileSystemException)throwable;
            Assertions.assertEquals((Object)code, (Object)fse.getCode());
            Assertions.assertEquals((int)params.length, (int)fse.getInfo().length);
            parmArray = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                String value = String.valueOf(params[i]);
                Matcher urlMatcher = URL_PATTERN.matcher(value);
                if (urlMatcher.find()) {
                    Matcher pwdMatcher = PASSWORD_PATTERN.matcher(value);
                    value = pwdMatcher.replaceFirst(":***@");
                }
                Assertions.assertEquals((Object)value, (Object)fse.getInfo()[i]);
                parmArray[i] = value;
            }
        }
        String message = Messages.getString((String)code, (Object[])parmArray);
        Assertions.assertEquals((Object)message, (Object)throwable.getMessage());
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static String getResourceTestDirectory() {
        return System.getProperty("test.basedir.res", "test-data");
    }

    public static String getTestDirectory() {
        return System.getProperty(TEST_BASE_DIR, "target/test-classes/test-data");
    }

    public static File getTestDirectory(String name) {
        File file = new File(VfsTestUtils.getTestDirectoryFile(), name);
        Assertions.assertTrue(((file = VfsTestUtils.getCanonicalFile(file)).isDirectory() || file.mkdirs() ? 1 : 0) != 0, (String)("Test directory \"" + file + "\" does not exist or is not a directory."));
        return file;
    }

    public static File getTestDirectoryFile() {
        if (baseDir == null) {
            String baseDirProp = VfsTestUtils.getTestDirectory();
            if (baseDirProp.startsWith("file://")) {
                try {
                    baseDir = VfsTestUtils.getCanonicalFile(new File(new URI(baseDirProp)));
                }
                catch (URISyntaxException e) {
                    baseDir = VfsTestUtils.getCanonicalFile(new File(baseDirProp));
                }
            } else {
                baseDir = VfsTestUtils.getCanonicalFile(new File(baseDirProp));
            }
        }
        return baseDir;
    }

    public static File getTestResource(String name) {
        return VfsTestUtils.getTestResource(name, true);
    }

    public static File getTestResource(String name, boolean mustExist) {
        File file = new File(VfsTestUtils.getTestDirectoryFile(), name);
        file = VfsTestUtils.getCanonicalFile(file);
        if (mustExist) {
            Assertions.assertTrue((boolean)file.exists(), (String)("Test file \"" + file + "\" does not exist."));
        } else {
            Assertions.assertFalse((boolean)file.exists(), (String)("Test file \"" + file + "\" should not exist."));
        }
        return file;
    }

    static {
        URL_PATTERN = Pattern.compile("[a-z]+://.*");
        PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    }
}

