/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.res;

import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.junit.jupiter.api.Assertions;

public class Vfs444TestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        ProviderTestSuite suite = new ProviderTestSuite(new Vfs444TestCase(), true);
        suite.addTests(Vfs444Tests.class);
        return suite;
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String baseDir = VfsTestUtils.getResourceTestDirectory();
        return manager.resolveFile("zip:res:" + baseDir + "/test.zip");
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("res", (FileProvider)new ResourceFileProvider());
        manager.addProvider("zip", (FileProvider)new ZipFileProvider());
    }

    public static class Vfs444Tests
    extends AbstractProviderTestCase {
        @org.junit.Test
        public void testResolveFullPathFile0() throws FileSystemException {
            FileObject result = this.getManager().resolveFile("res:test-data/test.zip");
            Assertions.assertTrue((boolean)result.exists());
        }

        @org.junit.Test
        public void testResolveFullPathFile1() throws FileSystemException {
            FileObject result = this.getManager().resolveFile("res:/test-data/test.zip");
            Assertions.assertTrue((boolean)result.exists());
        }

        @org.junit.Test
        public void testResolveFullPathFile2() throws FileSystemException {
            FileObject result = this.getManager().resolveFile("res://test-data/test.zip");
            Assertions.assertTrue((boolean)result.exists());
        }

        @org.junit.Test
        public void testResolveFullPathURI0() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res:test-data/test.zip");
            Assertions.assertTrue((boolean)result.isFile());
        }

        @org.junit.Test
        public void testResolveFullPathURI1() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res:/test-data/test.zip");
            Assertions.assertTrue((boolean)result.isFile());
        }

        @org.junit.Test
        public void testResolveFullPathURI2() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res://test-data/test.zip");
            Assertions.assertTrue((boolean)result.isFile());
        }

        @org.junit.Test
        public void testResolvePartialPath1() throws FileSystemException {
            FileName result = this.getManager().resolveURI("res:test-data");
            Assertions.assertTrue((boolean)result.isFile());
        }

        @org.junit.Test
        public void testResolvePartialPath2() throws FileSystemException {
            FileName root = this.getManager().resolveURI("res:test-data");
            FileName file = this.getManager().resolveName(root, "test.zip");
            String uri = file.getURI();
            FileObject result = this.getManager().resolveFile(uri);
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.exists());
        }
    }
}

