/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import java.io.File;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.provider.DelegateFileObject;
import org.apache.commons.vfs2.provider.test.DebugFileListener;
import org.apache.commons.vfs2.util.WeakRefFileListener;
import org.junit.Test;

public class JunctionTests
extends AbstractProviderTestCase {
    private FileObject getBaseDir() throws FileSystemException {
        File file = VfsTestUtils.getTestDirectoryFile();
        JunctionTests.assertTrue((boolean)file.exists());
        return this.getManager().toFileObject(file);
    }

    @Test
    public void testAncestors() throws Exception {
        FileSystem fs = this.getManager().createVirtualFileSystem("vfs://").getFileSystem();
        FileObject baseDir = this.getBaseDir();
        FileObject file = fs.resolveFile("/a/b");
        JunctionTests.assertFalse((boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertFalse((boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertFalse((boolean)file.exists());
        fs.addJunction("/a/b", baseDir);
        file = fs.resolveFile("/a/b");
        JunctionTests.assertTrue((String)"Does not exist", (boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertTrue((String)"Does not exist", (boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertTrue((String)"Does not exist", (boolean)file.exists());
    }

    public void testEvent() throws Exception {
        FileSystem fs = this.getManager().createVirtualFileSystem("vfs://").getFileSystem();
        FileObject baseDir = this.getBaseDir().resolveFile("junctiontest");
        fs.addJunction("/a", baseDir);
        FileObject file = fs.resolveFile("/a/hardref.txt");
        JunctionTests.assertSame((String)"VirtualFileSystem does not use DelegateFO anymore?", (Object)file.getClass(), DelegateFileObject.class);
        DebugFileListener listener1 = new DebugFileListener();
        file.getFileSystem().addListener(file, (FileListener)listener1);
        FileObject real1 = baseDir.resolveFile("hardref.txt");
        real1.createFile();
        JunctionTests.assertEquals((String)"Strong Listener was not notified (create)", (String)"Listener false true false", (String)listener1.toString());
        real1.delete();
        JunctionTests.assertEquals((String)"Strong Listener was not notified (delete)", (String)"Listener false true true", (String)listener1.toString());
        FileObject file2 = fs.resolveFile("/a/weakref.txt");
        JunctionTests.assertSame((String)"VirtualFileSystem does not use DelegateFO anymore?", (Object)file2.getClass(), DelegateFileObject.class);
        DebugFileListener listener2 = new DebugFileListener();
        WeakRefFileListener.installListener((FileObject)file2, (FileListener)listener2);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        FileObject real2 = baseDir.resolveFile("weakref.txt");
        real2.createFile();
        JunctionTests.assertEquals((String)"Weak Listener was abandoned", (String)"Listener false true false", (String)listener2.toString());
    }

    @Test
    public void testNestedJunction() throws Exception {
        FileSystem fs = this.getManager().createVirtualFileSystem("vfs:").getFileSystem();
        FileObject baseDir = this.getBaseDir();
        fs.addJunction("/a", baseDir);
        try {
            fs.addJunction("/a/b", baseDir);
            JunctionTests.fail();
        }
        catch (Exception e) {
            VfsTestUtils.assertSameMessage("vfs.impl/nested-junction.error", "vfs:/a/b", (Throwable)e);
        }
        try {
            fs.addJunction("/a", baseDir);
            JunctionTests.fail();
        }
        catch (Exception e) {
            VfsTestUtils.assertSameMessage("vfs.impl/nested-junction.error", "vfs:/a", (Throwable)e);
        }
    }
}

