/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import java.net.URI;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlFileNameParserTest {
    private void testJira739(String uriStr) throws Exception {
        URI uri = new URI(uriStr);
        FileName fileName = new UrlFileNameParser().parseUri(null, null, uriStr);
        Assertions.assertEquals((Object)uriStr, (Object)fileName.getURI());
        Assertions.assertEquals((Object)uri.getScheme(), (Object)fileName.getScheme());
    }

    @Test
    public void testJira739SchemeFile() throws Exception {
        this.testJira739("file:///");
    }

    @Test
    public void testJira739SchemeMaprfs() throws Exception {
        this.testJira739("maprfs:///");
    }

    @Test
    public void testJira739SchemeRam() throws Exception {
        this.testJira739("ram:///");
    }
}

