/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.AbstractClientHttpResponse;
import org.springframework.http.client.reactive.Jetty10HttpFieldsHelper;
import org.springframework.http.client.reactive.JettyHeadersAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

class JettyClientHttpResponse
extends AbstractClientHttpResponse {
    private static final Pattern SAMESITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");

    public JettyClientHttpResponse(ReactiveResponse reactiveResponse, Flux<DataBuffer> content) {
        super(reactiveResponse.getStatus(), JettyClientHttpResponse.adaptHeaders(reactiveResponse), JettyClientHttpResponse.adaptCookies(reactiveResponse), content);
    }

    private static HttpHeaders adaptHeaders(ReactiveResponse response) {
        Object headers = Jetty10HttpFieldsHelper.jetty10Present() ? Jetty10HttpFieldsHelper.getHttpHeaders(response.getResponse()) : new JettyHeadersAdapter(response.getHeaders());
        return HttpHeaders.readOnlyHttpHeaders(headers);
    }

    private static MultiValueMap<String, ResponseCookie> adaptCookies(ReactiveResponse response) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        HttpHeaders headers = JettyClientHttpResponse.adaptHeaders(response);
        List cookieHeader = (List)headers.get("Set-Cookie");
        if (!CollectionUtils.isEmpty((Collection)cookieHeader)) {
            cookieHeader.forEach(arg_0 -> JettyClientHttpResponse.lambda$adaptCookies$1((MultiValueMap)result, arg_0));
        }
        return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)result);
    }

    @Nullable
    private static String parseSameSite(String headerValue) {
        Matcher matcher = SAMESITE_PATTERN.matcher(headerValue);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private static /* synthetic */ void lambda$adaptCookies$1(MultiValueMap result, String header) {
        HttpCookie.parse(header).forEach(cookie -> result.add((Object)cookie.getName(), (Object)ResponseCookie.fromClientResponse(cookie.getName(), cookie.getValue()).domain(cookie.getDomain()).path(cookie.getPath()).maxAge(cookie.getMaxAge()).secure(cookie.getSecure()).httpOnly(cookie.isHttpOnly()).sameSite(JettyClientHttpResponse.parseSameSite(header)).build()));
    }
}

