/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.refresh;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OrderColumn;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Entity
public class RefreshToken
extends ServerAccessToken {
    private static final long serialVersionUID = 2837120382251693874L;
    private List<String> accessTokens = new LinkedList<String>();

    public RefreshToken(Client client, long lifetime) {
        super(client, "refresh", OAuthUtils.generateRandomTokenKey(), lifetime, OAuthUtils.getIssuedAt());
    }

    public RefreshToken(Client client, String tokenKey, long lifetime, long issuedAt) {
        super(client, "refresh", tokenKey, lifetime, issuedAt);
    }

    public RefreshToken(ServerAccessToken token, String key, List<String> accessTokens) {
        super(RefreshToken.validateTokenType(token, "refresh"), key);
        this.accessTokens = accessTokens;
    }

    public RefreshToken() {
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    public List<String> getAccessTokens() {
        return this.accessTokens;
    }

    public void setAccessTokens(List<String> accessTokens) {
        this.accessTokens = accessTokens;
    }

    public void addAccessToken(String token) {
        this.getAccessTokens().add(token);
    }

    public boolean removeAccessToken(String token) {
        return this.getAccessTokens().remove(token);
    }
}

