/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws;

import jakarta.xml.ws.WebFault;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.JavaClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator.WrapperBeanAnnotator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;
import org.apache.cxf.tools.util.AnnotationUtil;

public final class FaultBean {
    private static final String[] EXCLUDED_GETTER = new String[]{"getCause", "getLocalizedMessage", "getStackTrace", "getSuppressed", "getClass"};

    public boolean faultBeanExists(Class<?> exceptionClass) {
        String fb = this.getWebFaultBean(exceptionClass);
        if (!StringUtils.isEmpty((String)fb)) {
            try {
                return AnnotationUtil.loadClass((String)fb, (ClassLoader)exceptionClass.getClassLoader()) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String getWebFaultBean(Class<?> exceptionClass) {
        WebFault fault = exceptionClass.getAnnotation(WebFault.class);
        if (fault == null) {
            return null;
        }
        return fault.faultBean();
    }

    private boolean isWebFaultAbsent(Class<?> exceptionClass) {
        return StringUtils.isEmpty((String)this.getWebFaultBean(exceptionClass));
    }

    public WrapperBeanClass transform(Class<?> exceptionClass, String defaultPackage) {
        WrapperBeanClass jClass = new WrapperBeanClass();
        if (this.isWebFaultAbsent(exceptionClass)) {
            jClass.setName(exceptionClass.getSimpleName() + "Bean");
            jClass.setPackageName(defaultPackage);
        } else {
            jClass.setFullClassName(this.getWebFaultBean(exceptionClass));
        }
        this.buildBeanFields(exceptionClass, jClass);
        String pkg = PackageUtils.getPackageName(exceptionClass);
        if (pkg.length() > 0) {
            jClass.setElementName(new QName(PackageUtils.getNamespace((String)pkg), exceptionClass.getSimpleName()));
        } else {
            jClass.setElementName(new QName(PackageUtils.getNamespace((String)"defaultnamespace"), exceptionClass.getSimpleName()));
        }
        jClass.annotate(new WrapperBeanAnnotator(exceptionClass));
        return jClass;
    }

    private String getFieldName(Method method) {
        String name = method.getName().substring(3);
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private boolean isIncludedGetter(Method method) {
        return method.getName().startsWith("get") && !Arrays.asList(EXCLUDED_GETTER).contains(method.getName());
    }

    private void buildBeanFields(Class<?> exceptionClass, JavaClass jClass) {
        TreeMap<String, JavaField> fields = new TreeMap<String, JavaField>();
        for (Method method : exceptionClass.getMethods()) {
            if (!this.isIncludedGetter(method)) continue;
            JavaField field = new JavaField(this.getFieldName(method), method.getReturnType().getName(), "");
            field.setOwner((JavaInterface)jClass);
            fields.put(field.getName(), field);
        }
        for (Map.Entry entry : fields.entrySet()) {
            jClass.addField((JavaField)entry.getValue());
            jClass.appendGetter((JavaField)entry.getValue());
            jClass.appendSetter((JavaField)entry.getValue());
        }
    }
}

