/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.cxf.rs.security.httpsignature.filters.AbstractSignatureInFilter;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

@Provider
@Priority(value=1000)
public class VerifySignatureFilter
extends AbstractSignatureInFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestCtx) {
        byte[] messageBody = this.verifyDigest((MultivaluedMap<String, String>)requestCtx.getHeaders(), requestCtx.getEntityStream());
        if (messageBody != null) {
            requestCtx.setEntityStream((InputStream)new ByteArrayInputStream(messageBody));
        }
        this.verifySignature((MultivaluedMap<String, String>)requestCtx.getHeaders(), SignatureHeaderUtils.createRequestTarget(requestCtx.getUriInfo().getRequestUri()), requestCtx.getMethod(), messageBody);
    }

    @Override
    protected void handleException(Exception ex) {
        throw new BadRequestException((Throwable)ex);
    }
}

