/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.lang.invoke.MethodHandles;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcSharedStateManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.ScheduledLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcNodeManager
extends NodeManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long MAX_PAUSE_MILLIS = 2000L;
    private final Supplier<? extends SharedStateManager> sharedStateManagerFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledPrimaryLockFactory;
    private final Supplier<? extends ScheduledLeaseLock> scheduledBackupLockFactory;
    private SharedStateManager sharedStateManager;
    private ScheduledLeaseLock scheduledPrimaryLock;
    private ScheduledLeaseLock scheduledBackupLock;
    private final long lockAcquisitionTimeoutMillis;
    private volatile boolean interrupted = false;
    private final LeaseLock.Pauser pauser;

    public static JdbcNodeManager with(DatabaseStorageConfiguration configuration, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        JdbcNodeManager.validateTimeoutConfiguration(configuration);
        Object sqlProviderFactory = configuration.getSqlProviderFactory() != null ? configuration.getSqlProviderFactory() : new PropertySQLProvider.Factory(configuration.getConnectionProvider());
        String brokerId = UUID.randomUUID().toString();
        return JdbcNodeManager.usingConnectionProvider(brokerId, configuration.getJdbcLockExpirationMillis(), configuration.getJdbcLockRenewPeriodMillis(), configuration.getJdbcLockAcquisitionTimeoutMillis(), configuration.getJdbcAllowedTimeDiff(), configuration.getConnectionProvider(), sqlProviderFactory.create(configuration.getNodeManagerStoreTableName(), SQLProvider.DatabaseStoreType.NODE_MANAGER), scheduledExecutorService, executorFactory);
    }

    private static JdbcNodeManager usingConnectionProvider(String brokerId, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, long allowedTimeDiff, JDBCConnectionProvider connectionProvider, SQLProvider provider, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        return new JdbcNodeManager(() -> JdbcSharedStateManager.usingConnectionProvider(brokerId, lockExpirationMillis, lockRenewPeriodMillis, allowedTimeDiff, connectionProvider, provider), lockExpirationMillis, lockRenewPeriodMillis, lockAcquisitionTimeoutMillis, scheduledExecutorService, executorFactory);
    }

    private static void validateTimeoutConfiguration(DatabaseStorageConfiguration configuration) {
        long lockExpiration = configuration.getJdbcLockExpirationMillis();
        if (lockExpiration <= 0L) {
            throw new IllegalArgumentException("jdbc-lock-expiration should be positive");
        }
        long lockRenewPeriod = configuration.getJdbcLockRenewPeriodMillis();
        if (lockRenewPeriod <= 0L) {
            throw new IllegalArgumentException("jdbc-lock-renew-period should be positive");
        }
        if (lockRenewPeriod >= lockExpiration) {
            throw new IllegalArgumentException("jdbc-lock-renew-period should be < jdbc-lock-expiration");
        }
        int networkTimeout = configuration.getJdbcNetworkTimeout();
        if (networkTimeout >= 0) {
            if ((long)networkTimeout > lockExpiration) {
                logger.warn("jdbc-network-timeout isn't properly configured: the recommended value is <= jdbc-lock-expiration");
            }
        } else {
            logger.warn("jdbc-network-timeout isn't properly configured: the recommended value is <= jdbc-lock-expiration");
        }
    }

    private JdbcNodeManager(Supplier<? extends SharedStateManager> sharedStateManagerFactory, long lockExpirationMillis, long lockRenewPeriodMillis, long lockAcquisitionTimeoutMillis, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory) {
        super(false);
        this.lockAcquisitionTimeoutMillis = lockAcquisitionTimeoutMillis;
        this.pauser = LeaseLock.Pauser.sleep(Math.min(lockRenewPeriodMillis, 2000L), TimeUnit.MILLISECONDS);
        this.sharedStateManagerFactory = sharedStateManagerFactory;
        this.scheduledPrimaryLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "primary", this.sharedStateManager.primaryLock(), lockRenewPeriodMillis, this::notifyLostLock);
        this.scheduledBackupLockFactory = () -> ScheduledLeaseLock.of(scheduledExecutorService, executorFactory != null ? executorFactory.getExecutor() : null, "backup", this.sharedStateManager.backupLock(), lockRenewPeriodMillis, this::notifyLostLock);
        this.sharedStateManager = null;
        this.scheduledPrimaryLock = null;
        this.scheduledBackupLock = null;
    }

    @Override
    protected synchronized void notifyLostLock() {
        try {
            super.notifyLostLock();
        }
        finally {
            if (!this.isStarted()) {
                return;
            }
            try {
                this.stop();
            }
            catch (Exception ex) {
                logger.warn("Stopping node manager has errored on lost lock notification", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void start() throws Exception {
        try {
            if (this.isStarted()) {
                return;
            }
            this.sharedStateManager = this.sharedStateManagerFactory.get();
            logger.debug("setup sharedStateManager on start");
            org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.setup(() -> ((UUIDGenerator)UUIDGenerator.getInstance()).generateUUID());
            this.setUUID(nodeId);
            this.scheduledPrimaryLock = this.scheduledPrimaryLockFactory.get();
            this.scheduledBackupLock = this.scheduledBackupLockFactory.get();
            super.start();
        }
        catch (IllegalStateException e) {
            this.sharedStateManager = null;
            this.scheduledPrimaryLock = null;
            this.scheduledBackupLock = null;
            throw e;
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            try {
                this.scheduledPrimaryLock.stop();
                this.scheduledBackupLock.stop();
            }
            finally {
                super.stop();
                this.sharedStateManager.close();
                this.sharedStateManager = null;
                this.scheduledPrimaryLock = null;
                this.scheduledBackupLock = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws NodeManager.NodeManagerException {
        this.checkStarted();
        logger.debug("ENTER isAwaitingFailback");
        try {
            boolean bl = this.readSharedState() == SharedStateManager.State.FAILING_BACK;
            return bl;
        }
        catch (IllegalStateException e) {
            logger.warn("cannot retrieve shared state: assume it's not yet failed back", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.debug("EXIT isAwaitingFailback");
        }
    }

    @Override
    public boolean isBackupActive() throws NodeManager.NodeManagerException {
        this.checkStarted();
        logger.debug("ENTER isBackupActive");
        try {
            boolean bl = this.scheduledPrimaryLock.lock().isHeld();
            return bl;
        }
        catch (IllegalStateException e) {
            throw new NodeManager.NodeManagerException(e);
        }
        finally {
            logger.debug("EXIT isBackupActive");
        }
    }

    @Override
    public void interrupt() {
        logger.debug("ENTER interrupted");
        this.interrupted = true;
        logger.debug("EXIT interrupted");
    }

    @Override
    public void releaseBackup() throws NodeManager.NodeManagerException {
        this.checkStarted();
        logger.debug("ENTER releaseBackup");
        try {
            if (this.scheduledBackupLock.isStarted()) {
                logger.debug("scheduledBackupLock is running: stop it and release backup lock");
                this.scheduledBackupLock.stop();
                this.scheduledBackupLock.lock().release();
            } else {
                logger.debug("scheduledBackupLock is not running");
            }
        }
        catch (IllegalStateException e) {
            throw new NodeManager.NodeManagerException(e);
        }
        finally {
            logger.debug("EXIT releaseBackup");
        }
    }

    private void lock(LeaseLock lock) throws ActiveMQLockAcquisitionTimeoutException, InterruptedException {
        long lockAcquisitionTimeoutNanos = this.lockAcquisitionTimeoutMillis >= 0L ? TimeUnit.MILLISECONDS.toNanos(this.lockAcquisitionTimeoutMillis) : -1L;
        Enum acquireResult = null;
        long start = System.nanoTime();
        while (acquireResult == null) {
            this.checkStarted();
            long remainingNanos = JdbcNodeManager.remainingNanos(start, lockAcquisitionTimeoutNanos);
            if (remainingNanos == 0L) {
                acquireResult = LeaseLock.AcquireResult.Timeout;
                continue;
            }
            long remainingMillis = remainingNanos > 0L ? TimeUnit.NANOSECONDS.toMillis(remainingNanos) : -1L;
            try {
                acquireResult = lock.tryAcquire(remainingMillis, this.pauser, () -> !this.interrupted);
            }
            catch (IllegalStateException e) {
                logger.warn("Errored while trying to acquire lock", (Throwable)e);
                if (JdbcNodeManager.remainingNanos(start, lockAcquisitionTimeoutNanos) == 0L) {
                    acquireResult = LeaseLock.AcquireResult.Timeout;
                    continue;
                }
                this.pauser.idle();
            }
        }
        switch (2.$SwitchMap$org$apache$activemq$artemis$core$server$impl$jdbc$LeaseLock$AcquireResult[acquireResult.ordinal()]) {
            case 1: {
                throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
            }
            case 2: {
                this.interrupted = false;
                throw new InterruptedException("LeaseLock was interrupted");
            }
            case 3: {
                break;
            }
            default: {
                throw new AssertionError((Object)(String.valueOf(acquireResult) + " not managed"));
            }
        }
    }

    private static long remainingNanos(long start, long timeoutNanos) {
        if (timeoutNanos > 0L) {
            long elapsedNanos = System.nanoTime() - start;
            if (elapsedNanos < timeoutNanos) {
                return timeoutNanos - elapsedNanos;
            }
            return 0L;
        }
        assert (timeoutNanos == -1L);
        return -1L;
    }

    private void checkInterrupted(Supplier<String> message) throws InterruptedException {
        if (this.interrupted) {
            this.interrupted = false;
            throw new InterruptedException(message.get());
        }
    }

    private void renewLock(ScheduledLeaseLock lock) {
        boolean lostLock = true;
        IllegalStateException renewEx = null;
        try {
            lostLock = !this.scheduledPrimaryLock.lock().renew();
        }
        catch (IllegalStateException e) {
            renewEx = e;
        }
        if (lostLock) {
            this.notifyLostLock();
            if (renewEx == null) {
                renewEx = new IllegalStateException(lock.lockName() + " lock isn't renewed");
            }
            throw renewEx;
        }
    }

    private boolean lockPrimaryAndCheckActiveState() throws ActiveMQLockAcquisitionTimeoutException, InterruptedException {
        this.lock(this.scheduledPrimaryLock.lock());
        while (true) {
            long localExpirationTime;
            try {
                SharedStateManager.State stateWhileLocked = this.readSharedState();
                localExpirationTime = this.scheduledPrimaryLock.lock().localExpirationTime();
                if (System.currentTimeMillis() > localExpirationTime) {
                    return false;
                }
                if (stateWhileLocked == SharedStateManager.State.ACTIVE) {
                    return true;
                }
                this.scheduledPrimaryLock.lock().release();
                return false;
            }
            catch (IllegalStateException e) {
                logger.error("error while holding the primary node lock and tried to read the shared state or to release the lock", (Throwable)e);
                this.checkStarted();
                this.checkInterrupted(() -> "interrupt on error while checking state");
                this.pauser.idle();
                localExpirationTime = this.scheduledPrimaryLock.lock().localExpirationTime();
                if (System.currentTimeMillis() <= localExpirationTime) continue;
                return false;
            }
            break;
        }
    }

    @Override
    public void awaitPrimaryNode() throws NodeManager.NodeManagerException, InterruptedException {
        this.checkStarted();
        logger.debug("ENTER awaitPrimaryNode");
        try {
            boolean primaryWhileLocked = false;
            while (!primaryWhileLocked) {
                SharedStateManager.State state = null;
                try {
                    state = this.readSharedState();
                }
                catch (IllegalStateException e) {
                    logger.warn("Errored while reading shared state", (Throwable)e);
                }
                if (state == SharedStateManager.State.ACTIVE) {
                    primaryWhileLocked = this.lockPrimaryAndCheckActiveState();
                } else {
                    logger.debug("state while awaiting primary lock: {}", (Object)state);
                }
                if (primaryWhileLocked) continue;
                this.checkStarted();
                this.checkInterrupted(() -> "awaitPrimaryNode got interrupted!");
                this.pauser.idle();
            }
            logger.debug("acquired primary lock while state is {}: starting scheduledPrimaryLock", (Object)SharedStateManager.State.ACTIVE);
            this.scheduledPrimaryLock.start();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (IllegalStateException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
        finally {
            logger.debug("EXIT awaitPrimaryNode");
        }
    }

    @Override
    public void startBackup() throws NodeManager.NodeManagerException, InterruptedException {
        this.checkStarted();
        logger.debug("ENTER startBackup");
        try {
            ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
            this.lock(this.scheduledBackupLock.lock());
            this.scheduledBackupLock.start();
            ActiveMQServerLogger.LOGGER.gotBackupLock();
            if (this.getUUID() == null) {
                this.readNodeId();
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (IllegalStateException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
        finally {
            logger.debug("EXIT startBackup");
        }
    }

    @Override
    public ActivateCallback startPrimaryNode() throws NodeManager.NodeManagerException, InterruptedException {
        this.checkStarted();
        logger.debug("ENTER startPrimaryNode");
        try {
            boolean done = false;
            while (!done) {
                try {
                    this.setFailingBack();
                    done = true;
                }
                catch (IllegalStateException e) {
                    logger.warn("cannot set failing back state, retry", (Throwable)e);
                    this.pauser.idle();
                    this.checkInterrupted(() -> "interrupt while trying to set failing back state");
                }
            }
            String timeoutMessage = this.lockAcquisitionTimeoutMillis == -1L ? "indefinitely" : this.lockAcquisitionTimeoutMillis + " milliseconds";
            ActiveMQServerLogger.LOGGER.waitingToObtainPrimaryLock(timeoutMessage);
            this.lock(this.scheduledPrimaryLock.lock());
            this.scheduledPrimaryLock.start();
            ActiveMQServerLogger.LOGGER.obtainedPrimaryLock();
            CleaningActivateCallback cleaningActivateCallback = new CleaningActivateCallback(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void activationComplete() {
                    logger.debug("ENTER activationComplete");
                    try {
                        boolean done = false;
                        while (!done) {
                            try {
                                JdbcNodeManager.this.setActive();
                                done = true;
                            }
                            catch (IllegalStateException e) {
                                logger.warn("Errored while trying to setActive", (Throwable)e);
                                JdbcNodeManager.this.checkStarted();
                                JdbcNodeManager.this.pauser.idle();
                                long localExpirationTime = JdbcNodeManager.this.scheduledPrimaryLock.lock().localExpirationTime();
                                if (System.currentTimeMillis() <= localExpirationTime) continue;
                                throw new IllegalStateException("primary lock is probably expired: failed to setActive");
                                return;
                            }
                        }
                    }
                    catch (IllegalStateException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                        throw new NodeManager.NodeManagerException(e);
                    }
                    finally {
                        logger.debug("EXIT activationComplete");
                    }
                }
            };
            return cleaningActivateCallback;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (IllegalStateException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
        finally {
            logger.debug("EXIT startPrimaryNode");
        }
    }

    @Override
    public void pausePrimaryServer() throws NodeManager.NodeManagerException {
        this.checkStarted();
        logger.debug("ENTER pausePrimaryServer");
        try {
            if (this.scheduledPrimaryLock.isStarted()) {
                logger.debug("scheduledPrimaryLock is running: set paused shared state, stop it and release primary lock");
                this.setPaused();
                this.scheduledPrimaryLock.stop();
                this.scheduledPrimaryLock.lock().release();
            } else {
                logger.debug("scheduledPrimaryLock is not running: try renew primary lock");
                this.renewLock(this.scheduledPrimaryLock);
                logger.debug("primary lock renewed: set paused shared state and release primary lock");
                this.setPaused();
                this.scheduledPrimaryLock.lock().release();
            }
        }
        catch (IllegalStateException e) {
            throw new NodeManager.NodeManagerException(e);
        }
        finally {
            logger.debug("EXIT pausePrimaryServer");
        }
    }

    @Override
    public void crashPrimaryServer() throws NodeManager.NodeManagerException {
        this.checkStarted();
        logger.debug("ENTER crashPrimaryServer");
        try {
            if (this.scheduledPrimaryLock.isStarted()) {
                logger.debug("scheduledPrimaryLock is running: request stop it and release primary lock");
                this.scheduledPrimaryLock.stop();
                this.scheduledPrimaryLock.lock().release();
            } else {
                logger.debug("scheduledPrimaryLock is not running");
            }
        }
        finally {
            logger.debug("EXIT crashPrimaryServer");
        }
    }

    @Override
    public void awaitActiveStatus() {
        this.checkStarted();
        logger.debug("ENTER awaitActiveStatus");
        try {
            SharedStateManager.State state = null;
            while (state != SharedStateManager.State.ACTIVE) {
                try {
                    state = this.readSharedState();
                }
                catch (IllegalStateException e) {
                    logger.warn("Errored while trying to read shared state", (Throwable)e);
                }
                this.pauser.idle();
                this.checkStarted();
            }
        }
        finally {
            logger.debug("EXIT awaitActiveStatus");
        }
    }

    private void setActive() {
        this.writeSharedState(SharedStateManager.State.ACTIVE);
    }

    private void setFailingBack() {
        this.writeSharedState(SharedStateManager.State.FAILING_BACK);
    }

    private void setPaused() {
        this.writeSharedState(SharedStateManager.State.PAUSED);
    }

    private void writeSharedState(SharedStateManager.State state) {
        logger.debug("writeSharedState state = {}", (Object)state);
        this.sharedStateManager.writeState(state);
    }

    private SharedStateManager.State readSharedState() {
        SharedStateManager.State state = this.sharedStateManager.readState();
        logger.debug("readSharedState state = {}", (Object)state);
        return state;
    }

    @Override
    public SimpleString readNodeId() {
        this.checkStarted();
        org.apache.activemq.artemis.utils.UUID nodeId = this.sharedStateManager.readNodeId();
        logger.debug("readNodeId nodeId = {}", (Object)nodeId);
        this.setUUID(nodeId);
        return this.getNodeId();
    }
}

