/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.IterableMetadataSource;
import org.opensaml.saml.metadata.resolver.BatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.index.MetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.MetadataIndexManager;
import org.opensaml.saml.saml2.common.TimeBoundSAMLObject;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public abstract class AbstractBatchMetadataResolver
extends AbstractMetadataResolver
implements BatchMetadataResolver,
IterableMetadataSource {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractBatchMetadataResolver.class);
    private boolean cacheSourceMetadata;
    @Nonnull
    private Set<MetadataIndex> indexes = CollectionSupport.emptySet();
    private boolean resolveViaPredicatesOnly;

    public AbstractBatchMetadataResolver() {
        this.setCacheSourceMetadata(true);
    }

    public Iterator<EntityDescriptor> iterator() {
        this.checkComponentActive();
        return CollectionSupport.copyToList(this.ensureBackingStore().getOrderedDescriptors()).iterator();
    }

    protected boolean isCacheSourceMetadata() {
        return this.cacheSourceMetadata;
    }

    protected void setCacheSourceMetadata(boolean flag) {
        this.checkSetterPreconditions();
        this.cacheSourceMetadata = flag;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<MetadataIndex> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(@Nullable Set<MetadataIndex> newIndexes) {
        this.checkSetterPreconditions();
        this.indexes = newIndexes == null ? CollectionSupport.emptySet() : CollectionSupport.copyToSet(newIndexes);
    }

    public boolean isResolveViaPredicatesOnly() {
        return this.resolveViaPredicatesOnly;
    }

    public void setResolveViaPredicatesOnly(boolean flag) {
        this.checkSetterPreconditions();
        this.resolveViaPredicatesOnly = flag;
    }

    @Nullable
    public Instant getRootValidUntil() {
        XMLObject cached = this.ensureBackingStore().getCachedOriginalMetadata();
        if (cached != null && cached instanceof TimeBoundSAMLObject) {
            return ((TimeBoundSAMLObject)cached).getValidUntil();
        }
        return null;
    }

    @Nullable
    public Boolean isRootValid() {
        XMLObject cached = this.ensureBackingStore().getCachedOriginalMetadata();
        if (cached == null) {
            return null;
        }
        return this.isValid(cached);
    }

    @Override
    @Nonnull
    protected Iterable<EntityDescriptor> doResolve(@Nullable CriteriaSet criteria) throws ResolverException {
        EntityIdCriterion entityIdCriterion;
        this.checkComponentActive();
        EntityIdCriterion entityIdCriterion2 = entityIdCriterion = criteria != null ? (EntityIdCriterion)criteria.get(EntityIdCriterion.class) : null;
        if (entityIdCriterion != null) {
            List<EntityDescriptor> entityIdcandidates = this.lookupEntityID(entityIdCriterion.getEntityId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} Resolved {} candidates via EntityIdCriterion: {}", new Object[]{this.getLogPrefix(), Iterables.size(entityIdcandidates), entityIdCriterion});
            }
            return this.predicateFilterCandidates(entityIdcandidates, criteria, false);
        }
        Optional<Set<EntityDescriptor>> indexedCandidates = this.lookupByIndexes(criteria);
        if (this.log.isDebugEnabled()) {
            if (indexedCandidates.isPresent()) {
                this.log.debug("{} Resolved {} candidates via secondary index lookup", (Object)this.getLogPrefix(), (Object)Iterables.size((Iterable)indexedCandidates.get()));
            } else {
                this.log.debug("{} Resolved no candidates via secondary index lookup (Optional indicated result was absent)", (Object)this.getLogPrefix());
            }
        }
        if (indexedCandidates.isPresent()) {
            this.log.debug("{} Performing predicate filtering of resolved secondary indexed candidates", (Object)this.getLogPrefix());
            return this.predicateFilterCandidates((Iterable<EntityDescriptor>)indexedCandidates.get(), criteria, false);
        }
        if (this.isResolveViaPredicatesOnly()) {
            this.log.debug("{} Performing predicate filtering of entire metadata collection", (Object)this.getLogPrefix());
            return this.predicateFilterCandidates((Iterable<EntityDescriptor>)((Object)this), criteria, true);
        }
        this.log.debug("{} Resolved no secondary indexed candidates, returning empty result", (Object)this.getLogPrefix());
        return CollectionSupport.emptySet();
    }

    @Nonnull
    protected Optional<Set<EntityDescriptor>> lookupByIndexes(@Nullable CriteriaSet criteria) {
        return this.ensureBackingStore().getSecondaryIndexManager().lookupIndexedItems(criteria);
    }

    @Override
    protected void indexEntityDescriptor(@Nonnull EntityDescriptor entityDescriptor, @Nonnull AbstractMetadataResolver.EntityBackingStore backingStore) {
        super.indexEntityDescriptor(entityDescriptor, backingStore);
        ((BatchEntityBackingStore)backingStore).getSecondaryIndexManager().indexEntityDescriptor(entityDescriptor);
    }

    @Override
    @Nonnull
    protected BatchEntityBackingStore createNewBackingStore() {
        return new BatchEntityBackingStore(this.getIndexes());
    }

    @Override
    @Nonnull
    protected BatchEntityBackingStore ensureBackingStore() {
        return (BatchEntityBackingStore)super.ensureBackingStore();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
    }

    @Nullable
    protected XMLObject getCachedOriginalMetadata() {
        return this.ensureBackingStore().getCachedOriginalMetadata();
    }

    @Nullable
    protected XMLObject getCachedFilteredMetadata() {
        return this.ensureBackingStore().getCachedFilteredMetadata();
    }

    @Nonnull
    protected BatchEntityBackingStore preProcessNewMetadata(@Nonnull XMLObject root) throws FilterException {
        BatchEntityBackingStore newBackingStore = this.createNewBackingStore();
        XMLObject filteredMetadata = this.filterMetadata(root);
        if (this.isCacheSourceMetadata()) {
            newBackingStore.setCachedOriginalMetadata(root);
            newBackingStore.setCachedFilteredMetadata(filteredMetadata);
        }
        if (filteredMetadata == null) {
            this.log.info("{} Metadata filtering process produced a null document, resulting in an empty data set", (Object)this.getLogPrefix());
            return newBackingStore;
        }
        if (filteredMetadata instanceof EntityDescriptor) {
            this.preProcessEntityDescriptor((EntityDescriptor)filteredMetadata, newBackingStore);
        } else if (filteredMetadata instanceof EntitiesDescriptor) {
            this.preProcessEntitiesDescriptor((EntitiesDescriptor)filteredMetadata, newBackingStore);
        } else {
            this.log.warn("{} Document root was neither an EntityDescriptor nor an EntitiesDescriptor: {}", (Object)this.getLogPrefix(), (Object)root.getClass().getName());
        }
        return newBackingStore;
    }

    protected class BatchEntityBackingStore
    extends AbstractMetadataResolver.EntityBackingStore {
        @Nullable
        private XMLObject cachedOriginalMetadata;
        @Nullable
        private XMLObject cachedFilteredMetadata;
        @Nonnull
        private final MetadataIndexManager<EntityDescriptor> secondaryIndexManager;

        protected BatchEntityBackingStore(Set<MetadataIndex> initIndexes) {
            super(AbstractBatchMetadataResolver.this);
            this.secondaryIndexManager = new MetadataIndexManager<EntityDescriptor>(initIndexes, new MetadataIndexManager.IdentityExtractionFunction());
        }

        @Nullable
        public XMLObject getCachedOriginalMetadata() {
            return this.cachedOriginalMetadata;
        }

        @Nonnull
        public XMLObject ensureCachedOriginalMetadata() {
            if (this.cachedOriginalMetadata != null) {
                return this.cachedOriginalMetadata;
            }
            throw new IllegalStateException("Original metadata was absent.");
        }

        public void setCachedOriginalMetadata(@Nullable XMLObject metadata) {
            this.cachedOriginalMetadata = metadata;
        }

        @Nullable
        public XMLObject getCachedFilteredMetadata() {
            return this.cachedFilteredMetadata;
        }

        public void setCachedFilteredMetadata(@Nullable XMLObject metadata) {
            this.cachedFilteredMetadata = metadata;
        }

        @Nonnull
        public MetadataIndexManager<EntityDescriptor> getSecondaryIndexManager() {
            return this.secondaryIndexManager;
        }
    }
}

