/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpRequest;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

public class HttpClientSecurityContextHandler
extends AbstractInitializableComponent
implements HttpClientContextHandler {
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    public void invokeBefore(@Nonnull HttpClientContext context, @Nonnull ClassicHttpRequest request) throws IOException {
        this.checkComponentActive();
        HttpClientSecuritySupport.marshalSecurityParameters(context, this.httpClientSecurityParameters, false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria(context, (HttpRequest)request);
    }

    public void invokeAfter(@Nonnull HttpClientContext context, @Nonnull ClassicHttpRequest request) throws IOException {
        this.checkComponentActive();
        HttpClientSecuritySupport.checkTLSCredentialEvaluated(context, request.getScheme());
    }
}

