/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import org.apache.daffodil.runtime1.processors.dfa.DFADelimiter;
import scala.collection.mutable.ArrayBuffer;

public abstract class DelimiterIterator {
    private final ArrayBuffer delimiters;
    private int currentIndex;
    private int indexLimit;

    public DelimiterIterator(ArrayBuffer<DFADelimiter> delimiters) {
        this.delimiters = delimiters;
        this.currentIndex = -1;
        this.indexLimit = -1;
    }

    public ArrayBuffer<DFADelimiter> delimiters() {
        return this.delimiters;
    }

    public abstract boolean isOfInterest(DFADelimiter var1);

    public abstract int firstLocalIndex();

    public abstract void reset();

    public int currentIndex() {
        return this.currentIndex;
    }

    public void currentIndex_$eq(int x$1) {
        this.currentIndex = x$1;
    }

    public int indexLimit() {
        return this.indexLimit;
    }

    public void indexLimit_$eq(int x$1) {
        this.indexLimit = x$1;
    }

    public boolean hasNext() {
        this.currentIndex_$eq(this.currentIndex() + 1);
        while (this.currentIndex() >= 0 && this.currentIndex() < this.indexLimit()) {
            if (this.isOfInterest((DFADelimiter)this.delimiters().apply(this.currentIndex()))) {
                return true;
            }
            this.currentIndex_$eq(this.currentIndex() + 1);
        }
        return false;
    }

    public DFADelimiter next() {
        return (DFADelimiter)this.delimiters().apply(this.currentIndex());
    }

    public boolean isRemote() {
        return this.currentIndex() < this.firstLocalIndex();
    }
}

