/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.transform;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem$;
import scala.xml.Group;
import scala.xml.Group$;
import scala.xml.Node;
import scala.xml.NodeBuffer;

public abstract class BasicTransformer
implements Function1<Node, Node> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unchanged(Node n, Seq<Node> ns) {
        if (ns.length() != 1) return false;
        Object object = ns.head();
        Node node = n;
        if (object != null) {
            if (!object.equals(node)) return false;
            return true;
        }
        if (node == null) return true;
        return false;
    }

    public Seq<Node> transform(Iterator<Node> it, NodeBuffer nb) {
        return (Seq)it.foldLeft((Object)nb, (Function2 & Serializable)(_$1, _$2) -> (NodeBuffer)_$1.$plus$plus$eq((IterableOnce)this.transform((Node)_$2)));
    }

    public Seq<Node> transform(Seq<Node> ns) {
        Seq changed = (Seq)ns.flatMap((Function1 & Serializable)n -> this.transform((Node)n));
        if (changed.length() != ns.length() || ((IterableOnceOps)changed.zip(ns)).exists((Function1 & Serializable)p -> !BoxesRunTime.equals((Object)p._1(), (Object)p._2()))) {
            return changed;
        }
        return ns;
    }

    public Seq<Node> transform(Node n) {
        if (n.doTransform()) {
            Seq<Node> nch;
            Node node = n;
            if (node instanceof Group) {
                Seq<Node> seq;
                Group group = Group$.MODULE$.unapply((Group)node);
                Seq<Node> xs = seq = group._1();
                return Group$.MODULE$.apply(this.transform(xs));
            }
            scala.collection.immutable.Seq<Node> ch = n.child();
            if (ch == (nch = this.transform((Seq<Node>)ch))) {
                return n;
            }
            return Elem$.MODULE$.apply(n.prefix(), n.label(), n.attributes(), n.scope(), nch.isEmpty(), (scala.collection.immutable.Seq<Node>)nch.toSeq());
        }
        return n;
    }

    public Node apply(Node n) {
        Seq<Node> seq = this.transform(n);
        if (seq.length() > 1) {
            throw new UnsupportedOperationException("transform must return single node for root");
        }
        return (Node)seq.head();
    }
}

