/*
 * Decompiled with CFR 0.152.
 */
package shade.jamesmurty.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.iharder.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import shade.jamesmurty.utils.NamespaceContextImpl;
import shade.jamesmurty.utils.XMLBuilderRuntimeException;

public abstract class BaseXMLBuilder {
    private Document xmlDocument = null;
    private Node xmlNode = null;
    public static boolean failIfExternalEntityParsingCannotBeConfigured = true;

    protected BaseXMLBuilder(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xmlNode = xmlDocument.getDocumentElement();
    }

    protected BaseXMLBuilder(Node myNode, Node parentNode) {
        this.xmlNode = myNode;
        this.xmlDocument = myNode instanceof Document ? (Document)myNode : myNode.getOwnerDocument();
        if (parentNode != null) {
            parentNode.appendChild(myNode);
        }
    }

    protected static void enableOrDisableExternalEntityParsing(DocumentBuilderFactory factory2, boolean enableExternalEntities) {
        String[] externalGeneralEntitiesFeatures = new String[]{"http://xml.org/sax/features/external-general-entities", "http://xerces.apache.org/xerces-j/features.html#external-general-entities", "http://xerces.apache.org/xerces2-j/features.html#external-general-entities"};
        boolean success = false;
        for (String feature : externalGeneralEntitiesFeatures) {
            try {
                factory2.setFeature(feature, enableExternalEntities);
                success = true;
                break;
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
        }
        if (!success && failIfExternalEntityParsingCannotBeConfigured) {
            throw new XMLBuilderRuntimeException(new ParserConfigurationException("Failed to set 'external-general-entities' feature to " + enableExternalEntities));
        }
        String[] externalParameterEntitiesFeatures = new String[]{"http://xml.org/sax/features/external-parameter-entities", "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities"};
        success = false;
        for (String feature : externalParameterEntitiesFeatures) {
            try {
                factory2.setFeature(feature, enableExternalEntities);
                success = true;
                break;
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
        }
        if (!success && failIfExternalEntityParsingCannotBeConfigured) {
            throw new XMLBuilderRuntimeException(new ParserConfigurationException("Failed to set 'external-parameter-entities' feature to " + enableExternalEntities));
        }
    }

    protected static Document createDocumentImpl(String name, String namespaceURI, boolean enableExternalEntities, boolean isNamespaceAware) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        factory2.setNamespaceAware(isNamespaceAware);
        BaseXMLBuilder.enableOrDisableExternalEntityParsing(factory2, enableExternalEntities);
        DocumentBuilder builder = factory2.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = null;
        rootElement = namespaceURI != null && namespaceURI.length() > 0 ? document.createElementNS(namespaceURI, name) : document.createElement(name);
        document.appendChild(rootElement);
        return document;
    }

    protected static Document parseDocumentImpl(InputSource inputSource, boolean enableExternalEntities, boolean isNamespaceAware) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        factory2.setNamespaceAware(isNamespaceAware);
        BaseXMLBuilder.enableOrDisableExternalEntityParsing(factory2, enableExternalEntities);
        DocumentBuilder builder = factory2.newDocumentBuilder();
        Document document = builder.parse(inputSource);
        return document;
    }

    protected void stripWhitespaceOnlyTextNodesImpl() throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPathExpression xpathExp = xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
        NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(this.getDocument(), XPathConstants.NODESET);
        for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
            Node emptyTextNode = emptyTextNodes.item(i);
            emptyTextNode.getParentNode().removeChild(emptyTextNode);
        }
    }

    public abstract BaseXMLBuilder stripWhitespaceOnlyTextNodes() throws XPathExpressionException;

    protected void importXMLBuilderImpl(BaseXMLBuilder builder) {
        this.assertElementContainsNoOrWhitespaceOnlyTextNodes(this.xmlNode);
        Node importedNode = this.getDocument().importNode(builder.getDocument().getDocumentElement(), true);
        this.xmlNode.appendChild(importedNode);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BaseXMLBuilder) {
            BaseXMLBuilder other = (BaseXMLBuilder)obj;
            return this.xmlDocument.equals(other.getDocument()) && this.xmlNode.equals(other.getElement());
        }
        return false;
    }

    public Element getElement() {
        if (this.xmlNode instanceof Element) {
            return (Element)this.xmlNode;
        }
        return null;
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public abstract BaseXMLBuilder importXMLBuilder(BaseXMLBuilder var1);

    public abstract BaseXMLBuilder root();

    public Object xpathQuery(String xpath, QName type, NamespaceContext nsContext) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xPath = xpathFactory.newXPath();
        if (nsContext != null) {
            xPath.setNamespaceContext(nsContext);
        }
        XPathExpression xpathExp = xPath.compile(xpath);
        try {
            return xpathExp.evaluate(this.xmlNode, type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Object xpathQuery(String xpath, QName type) throws XPathExpressionException {
        return this.xpathQuery(xpath, type, null);
    }

    public abstract BaseXMLBuilder xpathFind(String var1, NamespaceContext var2) throws XPathExpressionException;

    public abstract BaseXMLBuilder xpathFind(String var1) throws XPathExpressionException;

    protected Node xpathFindImpl(String xpath, NamespaceContext nsContext) throws XPathExpressionException {
        Node foundNode = (Node)this.xpathQuery(xpath, XPathConstants.NODE, nsContext);
        if (foundNode == null || foundNode.getNodeType() != 1) {
            throw new XPathExpressionException("XPath expression \"" + xpath + "\" does not resolve to an Element in context " + this.xmlNode + ": " + foundNode);
        }
        return foundNode;
    }

    protected String lookupNamespaceURIImpl(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        String namespaceURI = this.xmlNode.lookupNamespaceURI(prefix);
        return namespaceURI;
    }

    protected Element elementImpl(String name, String namespaceURI) {
        this.assertElementContainsNoOrWhitespaceOnlyTextNodes(this.xmlNode);
        if (namespaceURI == null) {
            return this.getDocument().createElement(name);
        }
        return this.getDocument().createElementNS(namespaceURI, name);
    }

    public abstract BaseXMLBuilder element(String var1);

    public abstract BaseXMLBuilder elem(String var1);

    public abstract BaseXMLBuilder e(String var1);

    public abstract BaseXMLBuilder element(String var1, String var2);

    public abstract BaseXMLBuilder elementBefore(String var1);

    public abstract BaseXMLBuilder elementBefore(String var1, String var2);

    public abstract BaseXMLBuilder attribute(String var1, String var2);

    public abstract BaseXMLBuilder attr(String var1, String var2);

    public abstract BaseXMLBuilder a(String var1, String var2);

    public abstract BaseXMLBuilder text(String var1, boolean var2);

    public abstract BaseXMLBuilder text(String var1);

    public abstract BaseXMLBuilder t(String var1);

    protected Element elementBeforeImpl(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        String namespaceURI = this.xmlNode.lookupNamespaceURI(prefix);
        return this.elementBeforeImpl(name, namespaceURI);
    }

    protected Element elementBeforeImpl(String name, String namespaceURI) {
        Node parentNode = this.xmlNode.getParentNode();
        this.assertElementContainsNoOrWhitespaceOnlyTextNodes(parentNode);
        Element newElement = namespaceURI == null ? this.getDocument().createElement(name) : this.getDocument().createElementNS(namespaceURI, name);
        parentNode.insertBefore(newElement, this.xmlNode);
        return newElement;
    }

    protected void attributeImpl(String name, String value) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + this.xmlNode);
        }
        ((Element)this.xmlNode).setAttribute(name, value);
    }

    protected void textImpl(String value, boolean replaceText) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal null text value");
        }
        if (replaceText) {
            this.xmlNode.setTextContent(value);
        } else {
            this.xmlNode.appendChild(this.getDocument().createTextNode(value));
        }
    }

    protected void cdataImpl(String data) {
        this.xmlNode.appendChild(this.getDocument().createCDATASection(data));
    }

    protected void cdataImpl(byte[] data) {
        this.xmlNode.appendChild(this.getDocument().createCDATASection(Base64.encodeBytes((byte[])data)));
    }

    protected void commentImpl(String comment) {
        this.xmlNode.appendChild(this.getDocument().createComment(comment));
    }

    protected void instructionImpl(String target, String data) {
        this.xmlNode.appendChild(this.getDocument().createProcessingInstruction(target, data));
    }

    protected void insertInstructionImpl(String target, String data) {
        this.getDocument().insertBefore(this.getDocument().createProcessingInstruction(target, data), this.xmlNode);
    }

    protected void referenceImpl(String name) {
        this.xmlNode.appendChild(this.getDocument().createEntityReference(name));
    }

    protected void namespaceImpl(String prefix, String namespaceURI) {
        if (!(this.xmlNode instanceof Element)) {
            throw new RuntimeException("Cannot add an attribute to non-Element underlying node: " + this.xmlNode);
        }
        if (prefix != null && prefix.length() > 0) {
            ((Element)this.xmlNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
        } else {
            ((Element)this.xmlNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
        }
    }

    protected void namespaceImpl(String namespaceURI) {
        this.namespaceImpl(null, namespaceURI);
    }

    public abstract BaseXMLBuilder cdata(String var1);

    public abstract BaseXMLBuilder data(String var1);

    public abstract BaseXMLBuilder d(String var1);

    public abstract BaseXMLBuilder cdata(byte[] var1);

    public abstract BaseXMLBuilder data(byte[] var1);

    public abstract BaseXMLBuilder d(byte[] var1);

    public abstract BaseXMLBuilder comment(String var1);

    public abstract BaseXMLBuilder cmnt(String var1);

    public abstract BaseXMLBuilder c(String var1);

    public abstract BaseXMLBuilder instruction(String var1, String var2);

    public abstract BaseXMLBuilder inst(String var1, String var2);

    public abstract BaseXMLBuilder i(String var1, String var2);

    public abstract BaseXMLBuilder insertInstruction(String var1, String var2);

    public abstract BaseXMLBuilder reference(String var1);

    public abstract BaseXMLBuilder ref(String var1);

    public abstract BaseXMLBuilder r(String var1);

    public abstract BaseXMLBuilder namespace(String var1, String var2);

    public abstract BaseXMLBuilder ns(String var1, String var2);

    public abstract BaseXMLBuilder namespace(String var1);

    public abstract BaseXMLBuilder ns(String var1);

    public abstract BaseXMLBuilder up(int var1);

    public abstract BaseXMLBuilder up();

    public abstract BaseXMLBuilder document();

    protected Node upImpl(int steps) {
        Node currNode = this.xmlNode;
        for (int stepCount = 0; currNode.getParentNode() != null && stepCount < steps; ++stepCount) {
            currNode = currNode.getParentNode();
        }
        return currNode;
    }

    protected void assertElementContainsNoOrWhitespaceOnlyTextNodes(Node anXmlElement) {
        Node textNodeWithNonWhitespace = null;
        NodeList childNodes = anXmlElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node textNode;
            String textWithoutWhitespace;
            if (3 != childNodes.item(i).getNodeType() || (textWithoutWhitespace = (textNode = childNodes.item(i)).getTextContent().replaceAll("\\s", "")).length() <= 0) continue;
            textNodeWithNonWhitespace = textNode;
            break;
        }
        if (textNodeWithNonWhitespace != null) {
            throw new IllegalStateException("Cannot add sub-element to element <" + anXmlElement.getNodeName() + "> that contains a Text node that isn't purely whitespace: " + textNodeWithNonWhitespace);
        }
    }

    public void toWriter(boolean wholeDocument, Writer writer, Properties outputProperties) throws TransformerException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource domSource = null;
        domSource = wholeDocument ? new DOMSource(this.getDocument()) : new DOMSource(this.getElement());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        if (outputProperties != null) {
            for (Map.Entry<Object, Object> entry : outputProperties.entrySet()) {
                serializer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        serializer.transform(domSource, streamResult);
    }

    public void toWriter(Writer writer, Properties outputProperties) throws TransformerException {
        this.toWriter(true, writer, outputProperties);
    }

    public String asString(Properties outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter(writer, outputProperties);
        return writer.toString();
    }

    public String elementAsString(Properties outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter(false, writer, outputProperties);
        return writer.toString();
    }

    public String asString() throws TransformerException {
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return this.asString(outputProperties);
    }

    public String elementAsString() throws TransformerException {
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return this.elementAsString(outputProperties);
    }

    protected NamespaceContextImpl buildDocumentNamespaceContext() {
        return new NamespaceContextImpl(this.xmlDocument.getDocumentElement());
    }

    protected String getPrefixFromQualifiedName(String qualifiedName) {
        int colonPos = qualifiedName.indexOf(58);
        if (colonPos > 0) {
            return qualifiedName.substring(0, colonPos);
        }
        return null;
    }
}

