/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzSchedulerAutoConfiguration;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.quartz.SchedulerFactoryBeanCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration(after={DataSourceAutoConfiguration.class}, before={QuartzSchedulerAutoConfiguration.class})
@ConditionalOnClass(value={Scheduler.class})
@ConditionalOnProperty(prefix="scheduler-plugin.quartz", name={"using-separate-datasource"}, havingValue="true")
@EnableConfigurationProperties(value={QuartzDataSourceConfig.class})
public class QuartzSchedulerDataSourceAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzSchedulerDataSourceAutoConfiguration.class);

    @Bean
    @Order(value=1)
    public SchedulerFactoryBeanCustomizer schedulerFactoryBeanCustomizer(QuartzDataSourceConfig quartzDataSourceConfig, DataSource defaultDataSource) {
        return schedulerFactoryBean -> {
            if (!quartzDataSourceConfig.isUsingSeparateDatasource()) {
                return;
            }
            HikariConfig quartzHikariConfig = Optional.ofNullable(quartzDataSourceConfig.getHikari()).orElse(this.generateQuartzHikariConfigFromDataSource((HikariDataSource)defaultDataSource));
            HikariDataSource quartzDataSource = new HikariDataSource(quartzHikariConfig);
            schedulerFactoryBean.setDataSource((DataSource)quartzDataSource);
            schedulerFactoryBean.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager((DataSource)quartzDataSource));
        };
    }

    private HikariConfig generateQuartzHikariConfigFromDataSource(HikariDataSource hikariDataSource) {
        HikariConfig defaultQuartzHikariConfig = new HikariConfig();
        hikariDataSource.copyStateTo(defaultQuartzHikariConfig);
        defaultQuartzHikariConfig.setPoolName("QuartzHikariCP");
        return defaultQuartzHikariConfig;
    }

    @ConfigurationProperties(prefix="scheduler-plugin.quartz")
    public static class QuartzDataSourceConfig {
        private boolean usingSeparateDatasource = false;
        private HikariConfig hikari;

        @Generated
        public QuartzDataSourceConfig() {
        }

        @Generated
        public boolean isUsingSeparateDatasource() {
            return this.usingSeparateDatasource;
        }

        @Generated
        public HikariConfig getHikari() {
            return this.hikari;
        }

        @Generated
        public void setUsingSeparateDatasource(boolean usingSeparateDatasource) {
            this.usingSeparateDatasource = usingSeparateDatasource;
        }

        @Generated
        public void setHikari(HikariConfig hikari) {
            this.hikari = hikari;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QuartzDataSourceConfig)) {
                return false;
            }
            QuartzDataSourceConfig other = (QuartzDataSourceConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUsingSeparateDatasource() != other.isUsingSeparateDatasource()) {
                return false;
            }
            HikariConfig this$hikari = this.getHikari();
            HikariConfig other$hikari = other.getHikari();
            return !(this$hikari == null ? other$hikari != null : !this$hikari.equals(other$hikari));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QuartzDataSourceConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUsingSeparateDatasource() ? 79 : 97);
            HikariConfig $hikari = this.getHikari();
            result = result * 59 + ($hikari == null ? 43 : $hikari.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "QuartzSchedulerDataSourceAutoConfiguration.QuartzDataSourceConfig(usingSeparateDatasource=" + this.isUsingSeparateDatasource() + ", hikari=" + this.getHikari() + ")";
        }
    }
}

