/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.api.ResourceMetadata;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.task.api.TaskChannel;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.resource.ResourceContext;
import org.apache.dolphinscheduler.server.worker.metrics.WorkerServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutionContextUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutionContextUtils.class);

    public static void createTaskInstanceWorkingDirectory(TaskExecutionContext taskExecutionContext) throws TaskException {
        String taskInstanceWorkingDirectory = FileUtils.getTaskInstanceWorkingDirectory((int)taskExecutionContext.getTaskInstanceId());
        try {
            if (new File(taskInstanceWorkingDirectory).exists()) {
                FileUtils.deleteFile((String)taskInstanceWorkingDirectory);
                log.warn("The TaskInstance WorkingDirectory: {} is exist, will recreate again", (Object)taskInstanceWorkingDirectory);
            }
            FileUtils.createDirectoryWithPermission((Path)Paths.get(taskInstanceWorkingDirectory, new String[0]), (Set)FileUtils.PERMISSION_775);
            taskExecutionContext.setExecutePath(taskInstanceWorkingDirectory);
            taskExecutionContext.setAppInfoPath(FileUtils.getAppInfoPath((String)taskInstanceWorkingDirectory));
        }
        catch (Throwable ex) {
            throw new TaskException("Cannot create TaskInstance WorkingDirectory: " + taskInstanceWorkingDirectory + " failed", ex);
        }
    }

    public static ResourceContext downloadResourcesIfNeeded(TaskChannel taskChannel, StorageOperator storageOperator, TaskExecutionContext taskExecutionContext) {
        AbstractParameters abstractParameters = taskChannel.parseParameters(taskExecutionContext.getTaskParams());
        List resourceFilesList = abstractParameters.getResourceFilesList();
        if (CollectionUtils.isEmpty((Collection)resourceFilesList)) {
            log.debug("There is no resource file need to download");
            return new ResourceContext();
        }
        ResourceContext resourceContext = new ResourceContext();
        String taskWorkingDirectory = taskExecutionContext.getExecutePath();
        for (ResourceInfo resourceInfo : resourceFilesList) {
            String resourceAbsolutePathInStorage = resourceInfo.getResourceName();
            ResourceMetadata resourceMetaData = storageOperator.getResourceMetaData(resourceAbsolutePathInStorage);
            String resourceAbsolutePathInLocal = Paths.get(taskWorkingDirectory, resourceMetaData.getResourceRelativePath()).toString();
            File file = new File(resourceAbsolutePathInLocal);
            if (!file.exists()) {
                try {
                    long resourceDownloadStartTime = System.currentTimeMillis();
                    storageOperator.download(resourceAbsolutePathInStorage, resourceAbsolutePathInLocal, true);
                    log.info("Download resource file {} -> {} successfully", (Object)resourceAbsolutePathInStorage, (Object)resourceAbsolutePathInLocal);
                    FileUtils.setFileTo755((File)file);
                    WorkerServerMetrics.recordWorkerResourceDownloadTime(System.currentTimeMillis() - resourceDownloadStartTime);
                    WorkerServerMetrics.recordWorkerResourceDownloadSize(Files.size(Paths.get(resourceAbsolutePathInLocal, new String[0])));
                    WorkerServerMetrics.incWorkerResourceDownloadSuccessCount();
                }
                catch (Exception ex) {
                    WorkerServerMetrics.incWorkerResourceDownloadFailureCount();
                    throw new TaskException(String.format("Download resource file: %s error", resourceAbsolutePathInStorage), (Throwable)ex);
                }
            }
            ResourceContext.ResourceItem resourceItem = ResourceContext.ResourceItem.builder().resourceAbsolutePathInStorage(resourceAbsolutePathInStorage).resourceAbsolutePathInLocal(resourceAbsolutePathInLocal).build();
            resourceContext.addResourceItem(resourceItem);
        }
        return resourceContext;
    }

    public static void clearTaskInstanceWorkingDirectory(TaskExecutionContext taskExecutionContext) {
        String execPath = taskExecutionContext.getExecutePath();
        try {
            if (StringUtils.isNotEmpty((CharSequence)execPath)) {
                FileUtils.deleteFile((String)execPath);
                log.info("Deleted task exec directory: {}", (Object)execPath);
            }
        }
        catch (Exception e) {
            log.warn("Failed to delete task exec directory.", (Throwable)e);
        }
    }
}

