/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.models.CloningInfo;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.HostnameSslState;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.RedundancyMode;
import com.azure.resourcemanager.appservice.models.SiteAvailabilityState;
import com.azure.resourcemanager.appservice.models.SlotSwapStatus;
import com.azure.resourcemanager.appservice.models.SslState;
import com.azure.resourcemanager.appservice.models.UsageState;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class WebSiteBaseImpl
implements WebSiteBase {
    private final String key;
    private SiteInner innerObject;
    private final Set<String> hostNamesSet = new HashSet<String>();
    private final Set<String> enabledHostNamesSet = new HashSet<String>();
    private final Set<String> trafficManagerHostNamesSet = new HashSet<String>();
    private final Set<String> outboundIPAddressesSet = new HashSet<String>();
    private final Set<String> possibleOutboundIPAddressesSet = new HashSet<String>();
    private final Map<String, HostnameSslState> hostNameSslStateMap = new HashMap<String, HostnameSslState>();
    private final Set<String> clientCertExclusionPathSet = new HashSet<String>();

    WebSiteBaseImpl(SiteInner innerObject) {
        this.key = UUID.randomUUID().toString();
        this.setInner(innerObject);
    }

    @Override
    public String state() {
        return this.innerModel().state();
    }

    @Override
    public Set<String> hostnames() {
        return Collections.unmodifiableSet(this.hostNamesSet);
    }

    @Override
    public String repositorySiteName() {
        return this.innerModel().repositorySiteName();
    }

    @Override
    public UsageState usageState() {
        return this.innerModel().usageState();
    }

    @Override
    public boolean enabled() {
        return this.innerModel().enabled() == null || this.innerModel().enabled() != false;
    }

    @Override
    public Set<String> enabledHostNames() {
        return Collections.unmodifiableSet(this.enabledHostNamesSet);
    }

    @Override
    public SiteAvailabilityState availabilityState() {
        return this.innerModel().availabilityState();
    }

    @Override
    public Map<String, HostnameSslState> hostnameSslStates() {
        return Collections.unmodifiableMap(this.hostNameSslStateMap);
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTimeUtc();
    }

    @Override
    public Set<String> trafficManagerHostNames() {
        return Collections.unmodifiableSet(this.trafficManagerHostNamesSet);
    }

    @Override
    public boolean scmSiteAlsoStopped() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().scmSiteAlsoStopped());
    }

    @Override
    public String targetSwapSlot() {
        return this.innerModel().targetSwapSlot();
    }

    @Override
    public boolean clientAffinityEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().clientAffinityEnabled());
    }

    @Override
    public boolean clientCertEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().clientCertEnabled());
    }

    @Override
    public boolean hostnamesDisabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().hostNamesDisabled());
    }

    @Override
    public Set<String> outboundIPAddresses() {
        return Collections.unmodifiableSet(this.outboundIPAddressesSet);
    }

    @Override
    public int containerSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().containerSize());
    }

    @Override
    public CloningInfo cloningInfo() {
        return this.innerModel().cloningInfo();
    }

    @Override
    public boolean isDefaultContainer() {
        return this.innerModel().isDefaultContainer() == null || this.innerModel().isDefaultContainer() != false;
    }

    @Override
    public String defaultHostname() {
        return this.innerModel().defaultHostname();
    }

    @Override
    public boolean httpsOnly() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().httpsOnly());
    }

    @Override
    public String appServicePlanId() {
        return this.innerModel().serverFarmId();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    private boolean reserved() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().reserved());
    }

    @Override
    public boolean hyperV() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().hyperV());
    }

    @Override
    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.innerModel().hostingEnvironmentProfile();
    }

    @Override
    public Set<String> clientCertExclusionPaths() {
        return Collections.unmodifiableSet(this.clientCertExclusionPathSet);
    }

    @Override
    public Set<String> possibleOutboundIpAddresses() {
        return Collections.unmodifiableSet(this.possibleOutboundIPAddressesSet);
    }

    @Override
    public int dailyMemoryTimeQuota() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().dailyMemoryTimeQuota());
    }

    @Override
    public OffsetDateTime suspendedTill() {
        return this.innerModel().suspendedTill();
    }

    @Override
    public int maxNumberOfWorkers() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().maxNumberOfWorkers());
    }

    @Override
    public SlotSwapStatus slotSwapStatus() {
        return this.innerModel().slotSwapStatus();
    }

    @Override
    public RedundancyMode redundancyMode() {
        return this.innerModel().redundancyMode();
    }

    @Override
    public OperatingSystem operatingSystem() {
        return this.reserved() ? OperatingSystem.LINUX : OperatingSystem.WINDOWS;
    }

    public String resourceGroupName() {
        return this.innerModel().resourceGroup();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String regionName() {
        return this.innerModel().location();
    }

    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    public Map<String, String> tags() {
        return Collections.unmodifiableMap(this.innerModel().tags());
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public SiteInner innerModel() {
        return this.innerObject;
    }

    protected void setInner(SiteInner innerObject) {
        this.innerObject = innerObject;
        this.hostNamesSet.clear();
        if (this.innerModel().hostNames() != null) {
            this.hostNamesSet.addAll(this.innerModel().hostNames());
        }
        this.enabledHostNamesSet.clear();
        if (this.innerModel().enabledHostNames() != null) {
            this.enabledHostNamesSet.addAll(this.innerModel().enabledHostNames());
        }
        this.trafficManagerHostNamesSet.clear();
        if (this.innerModel().trafficManagerHostNames() != null) {
            this.trafficManagerHostNamesSet.addAll(this.innerModel().trafficManagerHostNames());
        }
        this.outboundIPAddressesSet.clear();
        if (this.innerModel().outboundIpAddresses() != null) {
            this.outboundIPAddressesSet.addAll(Arrays.asList(this.innerModel().outboundIpAddresses().split(",[ ]*")));
        }
        this.possibleOutboundIPAddressesSet.clear();
        if (this.innerModel().possibleOutboundIpAddresses() != null) {
            this.possibleOutboundIPAddressesSet.addAll(Arrays.asList(this.innerModel().possibleOutboundIpAddresses().split(",[ ]*")));
        }
        this.hostNameSslStateMap.clear();
        if (this.innerModel().hostnameSslStates() != null) {
            for (HostnameSslState hostNameSslState : this.innerModel().hostnameSslStates()) {
                if (hostNameSslState.sslState() == null) {
                    hostNameSslState.withSslState(SslState.DISABLED);
                }
                this.hostNameSslStateMap.put(hostNameSslState.name(), hostNameSslState);
            }
        }
        this.clientCertExclusionPathSet.clear();
        if (this.innerModel().clientCertExclusionPaths() != null) {
            this.clientCertExclusionPathSet.addAll(Arrays.asList(this.innerModel().clientCertExclusionPaths().split(",[ ]*")));
        }
    }

    public String key() {
        return this.key;
    }
}

