/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.ITaskGroupCoordinator;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.AbstractTaskInstanceFactory;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskInstanceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FailoverTaskInstanceFactory
extends AbstractTaskInstanceFactory<FailoverTaskInstanceBuilder> {
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private ITaskGroupCoordinator taskGroupCoordinator;

    @Override
    public FailoverTaskInstanceBuilder builder() {
        return new FailoverTaskInstanceBuilder(this);
    }

    @Override
    @Transactional
    public TaskInstance createTaskInstance(FailoverTaskInstanceBuilder builder) {
        TaskInstance needFailoverTaskInstance = builder.needFailoverTaskInstance;
        TaskInstance taskInstance = this.cloneTaskInstance(needFailoverTaskInstance);
        taskInstance.setId(null);
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        taskInstance.setHost(null);
        taskInstance.setVarPool(null);
        taskInstance.setSubmitTime(new Date());
        taskInstance.setLogPath(null);
        taskInstance.setExecutePath(null);
        this.taskInstanceDao.insert((Object)taskInstance);
        if (this.taskGroupCoordinator.needToReleaseTaskGroupSlot(needFailoverTaskInstance)) {
            this.taskGroupCoordinator.releaseTaskGroupSlot(needFailoverTaskInstance);
        }
        needFailoverTaskInstance.setFlag(Flag.NO);
        needFailoverTaskInstance.setState(TaskExecutionStatus.NEED_FAULT_TOLERANCE);
        this.taskInstanceDao.updateById((Object)needFailoverTaskInstance);
        return taskInstance;
    }

    public static class FailoverTaskInstanceBuilder
    implements ITaskInstanceFactory.ITaskInstanceBuilder {
        private final FailoverTaskInstanceFactory failoverTaskInstanceFactory;
        private TaskInstance needFailoverTaskInstance;

        public FailoverTaskInstanceBuilder(FailoverTaskInstanceFactory failoverTaskInstanceFactory) {
            this.failoverTaskInstanceFactory = failoverTaskInstanceFactory;
        }

        public FailoverTaskInstanceBuilder withTaskInstance(TaskInstance needFailoverTaskInstance) {
            this.needFailoverTaskInstance = needFailoverTaskInstance;
            return this;
        }

        @Override
        public TaskInstance build() {
            return this.failoverTaskInstanceFactory.createTaskInstance(this);
        }
    }
}

