/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.repository.ScheduleDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionDao;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowScheduleTriggerRequest;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobData;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobKey;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ProcessScheduleTask
extends QuartzJobBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessScheduleTask.class);
    @Autowired
    private ScheduleDao scheduleDao;
    @Autowired
    private WorkflowDefinitionDao workflowDefinitionDao;
    @Autowired
    private IWorkflowControlClient workflowInstanceController;

    @Counted(value="ds.master.quartz.job.executed")
    @Timed(value="ds.master.quartz.job.execution.time", percentiles={0.5, 0.75, 0.95, 0.99}, histogram=true)
    protected void executeInternal(JobExecutionContext context) {
        QuartzJobData quartzJobData = QuartzJobData.of(context.getJobDetail().getJobDataMap());
        int projectId = quartzJobData.getProjectId();
        int scheduleId = quartzJobData.getScheduleId();
        Date scheduledFireTime = context.getScheduledFireTime();
        Date fireTime = context.getFireTime();
        log.info("Scheduler: {} fired expect fire time is {}, actual fire time is {}", new Object[]{scheduleId, scheduledFireTime, fireTime});
        Schedule schedule = (Schedule)this.scheduleDao.queryById((Serializable)Integer.valueOf(scheduleId));
        if (schedule == null || ReleaseState.OFFLINE == schedule.getReleaseState()) {
            log.warn("Scheduler: {} does not exist in db\uff0cwill delete job in quartz", (Object)scheduleId);
            this.deleteJob(context, projectId, scheduleId);
            return;
        }
        Optional workflowDefinitionOptional = this.workflowDefinitionDao.queryByCode(schedule.getWorkflowDefinitionCode());
        if (!workflowDefinitionOptional.isPresent()) {
            log.warn("Scheduler: {} bind workflow: {} does not exist in db\uff0cwill delete the schedule and delete schedule job in quartz", (Object)scheduleId, (Object)schedule.getWorkflowDefinitionCode());
            this.scheduleDao.deleteById((Serializable)Integer.valueOf(scheduleId));
            this.deleteJob(context, projectId, scheduleId);
            return;
        }
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)workflowDefinitionOptional.get();
        if (workflowDefinition.getReleaseState() == ReleaseState.OFFLINE) {
            log.warn("Scheduler: {} bind workflow: {} state is OFFLINE\uff0cwill update the schedule status to OFFLINE and delete schedule job in quartz", (Object)scheduleId, (Object)schedule.getWorkflowDefinitionCode());
            schedule.setReleaseState(ReleaseState.OFFLINE);
            schedule.setUpdateTime(new Date());
            this.scheduleDao.updateById((Object)schedule);
            this.deleteJob(context, projectId, scheduleId);
            return;
        }
        WorkflowScheduleTriggerRequest scheduleTriggerRequest = WorkflowScheduleTriggerRequest.builder().userId(Integer.valueOf(schedule.getUserId())).scheduleTIme(scheduledFireTime).timezoneId(schedule.getTimezoneId()).workflowCode(Long.valueOf(workflowDefinition.getCode())).workflowVersion(Integer.valueOf(workflowDefinition.getVersion())).failureStrategy(schedule.getFailureStrategy()).taskDependType(TaskDependType.TASK_POST).warningType(schedule.getWarningType()).warningGroupId(Integer.valueOf(schedule.getWarningGroupId())).workflowInstancePriority(schedule.getWorkflowInstancePriority()).workerGroup(WorkerGroupUtils.getWorkerGroupOrDefault((String)schedule.getWorkerGroup())).tenantCode(schedule.getTenantCode()).environmentCode(schedule.getEnvironmentCode()).dryRun(Flag.NO).build();
        this.workflowInstanceController.scheduleTriggerWorkflow(scheduleTriggerRequest);
    }

    private void deleteJob(JobExecutionContext context, int projectId, int scheduleId) {
        Scheduler scheduler = context.getScheduler();
        JobKey jobKey = QuartzJobKey.of(projectId, scheduleId).toJobKey();
        try {
            if (scheduler.checkExists(jobKey)) {
                log.info("Try to delete job: {}, projectId: {}, schedulerId: {}", new Object[]{jobKey, projectId, scheduleId});
                scheduler.deleteJob(jobKey);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete job: {}", (Object)jobKey, (Object)e);
        }
    }
}

