/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

public final class MetricAlertPropertiesPatch {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="severity")
    private Integer severity;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="scopes")
    private List<String> scopes;
    @JsonProperty(value="evaluationFrequency")
    private Duration evaluationFrequency;
    @JsonProperty(value="windowSize")
    private Duration windowSize;
    @JsonProperty(value="targetResourceType")
    private String targetResourceType;
    @JsonProperty(value="targetResourceRegion")
    private String targetResourceRegion;
    @JsonProperty(value="criteria")
    private MetricAlertCriteria criteria;
    @JsonProperty(value="autoMitigate")
    private Boolean autoMitigate;
    @JsonProperty(value="actions")
    private List<MetricAlertAction> actions;
    @JsonProperty(value="lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="isMigrated", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isMigrated;

    public String description() {
        return this.description;
    }

    public MetricAlertPropertiesPatch withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer severity() {
        return this.severity;
    }

    public MetricAlertPropertiesPatch withSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public MetricAlertPropertiesPatch withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public MetricAlertPropertiesPatch withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public MetricAlertPropertiesPatch withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public MetricAlertPropertiesPatch withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public MetricAlertPropertiesPatch withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    public MetricAlertPropertiesPatch withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    public MetricAlertPropertiesPatch withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public MetricAlertPropertiesPatch withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    public MetricAlertPropertiesPatch withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public void validate() {
        if (this.criteria() != null) {
            this.criteria().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

