/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public class StableLimitingSorter<T> {
    private final MinMaxPriorityQueue<NumberedElement<T>> queue;
    private final int limit;
    private long size = 0L;

    public StableLimitingSorter(Comparator<T> comparator, int limit) {
        this.limit = limit;
        this.queue = MinMaxPriorityQueue.orderedBy((Comparator)Ordering.from(Comparator.comparing(NumberedElement::getElement, comparator).thenComparing(NumberedElement::getNumber))).maximumSize(limit).create();
    }

    public void add(T element) {
        this.queue.offer(new NumberedElement<T>(element, this.size++));
    }

    public int size() {
        return Ints.checkedCast((long)Math.min(this.size, (long)this.limit));
    }

    public Iterator<T> drain() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return !StableLimitingSorter.this.queue.isEmpty();
            }

            @Override
            public T next() {
                return ((NumberedElement)StableLimitingSorter.this.queue.poll()).getElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @VisibleForTesting
    static class NumberedElement<T> {
        private final T element;
        private final long number;

        public NumberedElement(T element, long number) {
            this.element = element;
            this.number = number;
        }

        public T getElement() {
            return this.element;
        }

        public long getNumber() {
            return this.number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberedElement that = (NumberedElement)o;
            return this.number == that.number && Objects.equals(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hash(this.element, this.number);
        }
    }
}

