/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;

public class InputRowSchema {
    private final TimestampSpec timestampSpec;
    private final DimensionsSpec dimensionsSpec;
    private final ColumnsFilter columnsFilter;
    @NotNull
    private final Set<String> metricNames;

    public InputRowSchema(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, ColumnsFilter columnsFilter) {
        this(timestampSpec, dimensionsSpec, columnsFilter, (Set<String>)ImmutableSet.of());
    }

    public InputRowSchema(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, ColumnsFilter columnsFilter, Set<String> metricNames) {
        this.timestampSpec = timestampSpec;
        this.dimensionsSpec = dimensionsSpec;
        this.columnsFilter = columnsFilter;
        this.metricNames = metricNames == null ? ImmutableSet.of() : metricNames;
    }

    @NotNull
    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public ColumnsFilter getColumnsFilter() {
        return this.columnsFilter;
    }
}

