/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.channel.ReadableByteChunksFrameChannel;
import org.apache.druid.frame.file.FrameFilePartialFetch;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class FrameFileHttpResponseHandler
implements HttpResponseHandler<FrameFilePartialFetch, FrameFilePartialFetch> {
    public static final String HEADER_LAST_FETCH_NAME = "X-Druid-Frame-Last-Fetch";
    public static final String HEADER_LAST_FETCH_VALUE = "yes";
    private final ReadableByteChunksFrameChannel channel;
    private final long startOffset;

    public FrameFileHttpResponseHandler(ReadableByteChunksFrameChannel channel) {
        this.channel = (ReadableByteChunksFrameChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.startOffset = channel.getBytesAdded();
    }

    @Override
    public ClientResponse<FrameFilePartialFetch> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        if (response.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
            ClientResponse<FrameFilePartialFetch> clientResponse = ClientResponse.unfinished(new FrameFilePartialFetch(false));
            this.exceptionCaught(clientResponse, (Throwable)new ISE("Server for [%s] returned [%s]", this.channel.getId(), response.getStatus()));
            return clientResponse;
        }
        boolean lastFetchHeaderSet = HEADER_LAST_FETCH_VALUE.equals(response.headers().get(HEADER_LAST_FETCH_NAME));
        ClientResponse<FrameFilePartialFetch> clientResponse = ClientResponse.unfinished(new FrameFilePartialFetch(lastFetchHeaderSet));
        return this.response(clientResponse, response.getContent());
    }

    @Override
    public ClientResponse<FrameFilePartialFetch> handleChunk(ClientResponse<FrameFilePartialFetch> clientResponse, HttpChunk chunk, long chunkNum) {
        return this.response(clientResponse, chunk.getContent());
    }

    @Override
    public ClientResponse<FrameFilePartialFetch> done(ClientResponse<FrameFilePartialFetch> clientResponse) {
        return ClientResponse.finished(clientResponse.getObj());
    }

    @Override
    public void exceptionCaught(ClientResponse<FrameFilePartialFetch> clientResponse, Throwable e) {
        clientResponse.getObj().exceptionCaught(e);
    }

    private ClientResponse<FrameFilePartialFetch> response(ClientResponse<FrameFilePartialFetch> clientResponse, ChannelBuffer content) {
        long readByThisRequest;
        FrameFilePartialFetch clientResponseObj = clientResponse.getObj();
        if (clientResponseObj.isExceptionCaught()) {
            return ClientResponse.finished(clientResponseObj);
        }
        int chunkSize = content.readableBytes();
        long readByThisHandler = this.channel.getBytesAdded() - this.startOffset;
        long toSkip = readByThisHandler - (readByThisRequest = clientResponseObj.getBytesRead());
        if (toSkip < 0L) {
            throw DruidException.defensive("Expected toSkip[%d] to be nonnegative", toSkip);
        }
        if (toSkip < (long)chunkSize) {
            byte[] chunk = new byte[chunkSize - (int)toSkip];
            content.getBytes(content.readerIndex() + (int)toSkip, chunk);
            try {
                ListenableFuture<?> backpressureFuture = this.channel.addChunk(chunk);
                if (backpressureFuture != null) {
                    clientResponseObj.setBackpressureFuture(backpressureFuture);
                }
            }
            catch (Exception e) {
                clientResponseObj.exceptionCaught(e);
            }
        }
        clientResponseObj.addBytesRead(chunkSize);
        return ClientResponse.unfinished(clientResponseObj);
    }
}

