/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.math.LongMath;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.NumericArrayFrameColumnReader;
import org.apache.druid.segment.column.ColumnType;

public class LongArrayFrameColumnReader
extends NumericArrayFrameColumnReader {
    public LongArrayFrameColumnReader(int columnNumber) {
        super((byte)7, ColumnType.LONG_ARRAY, columnNumber);
    }

    @Override
    NumericArrayFrameColumnReader.NumericArrayFrameColumn column(Frame frame, Memory memory, ColumnType columnType) {
        return new LongArrayFrameColumn(frame, memory, columnType);
    }

    private static class LongArrayFrameColumn
    extends NumericArrayFrameColumnReader.NumericArrayFrameColumn {
        public LongArrayFrameColumn(Frame frame, Memory memory, ColumnType columnType) {
            super(frame, memory, columnType);
        }

        @Override
        Number getElement(Memory memory, long rowDataOffset, int cumulativeIndex) {
            return memory.getLong(LongMath.checkedAdd((long)rowDataOffset, (long)((long)cumulativeIndex * 8L)));
        }
    }
}

