/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerProvider;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataJsonSerializer;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.segment.virtual.NestedMergeVirtualColumn;
import org.apache.druid.segment.virtual.NestedObjectVirtualColumn;

public class BuiltInTypesModule
implements DruidModule {
    private static DimensionSchema.MultiValueHandling STRING_MV_MODE = DimensionSchema.MultiValueHandling.SORTED_ARRAY;
    private static IndexSpec DEFAULT_INDEX_SPEC = IndexSpec.builder().build();

    public static DimensionSchema.MultiValueHandling getStringMultiValueHandlingMode() {
        return STRING_MV_MODE;
    }

    public static IndexSpec getDefaultIndexSpec() {
        return DEFAULT_INDEX_SPEC;
    }

    @Override
    public List<? extends Module> getJacksonModules() {
        return BuiltInTypesModule.getJacksonModulesList();
    }

    public void configure(Binder binder) {
        BuiltInTypesModule.registerSerde();
        LifecycleModule.register(binder, SideEffectRegisterer.class);
    }

    @Provides
    @LazySingleton
    public SideEffectRegisterer initDimensionHandlerAndMvHandlingMode(DefaultColumnFormatConfig formatsConfig) {
        BuiltInTypesModule.setStringMultiValueHandlingModeIfConfigured(formatsConfig.getStringMultiValueHandlingMode());
        BuiltInTypesModule.setIndexSpecDefaults(formatsConfig.getIndexSpec());
        BuiltInTypesModule.setNestedColumnDefaults(formatsConfig);
        return new SideEffectRegisterer();
    }

    public static List<SimpleModule> getJacksonModulesList() {
        return Collections.singletonList(new SimpleModule("NestedDataModule").registerSubtypes(new Class[]{NestedFieldVirtualColumn.class, NestedMergeVirtualColumn.class, NestedObjectVirtualColumn.class}).addSerializer(StructuredData.class, (JsonSerializer)new StructuredDataJsonSerializer()));
    }

    @VisibleForTesting
    public static void registerHandlersAndSerde() {
        BuiltInTypesModule.registerSerde();
        DimensionHandlerUtils.registerDimensionHandlerProvider("json", new NestedCommonFormatHandlerProvider());
    }

    private static void registerSerde() {
        if (ComplexMetrics.getSerdeForType("json") == null) {
            ComplexMetrics.registerSerde("json", NestedDataComplexTypeSerde.INSTANCE);
        }
    }

    private static void setStringMultiValueHandlingModeIfConfigured(@Nullable String stringMultiValueHandlingMode) {
        if (stringMultiValueHandlingMode != null) {
            STRING_MV_MODE = DimensionSchema.MultiValueHandling.fromString(stringMultiValueHandlingMode);
        }
    }

    @VisibleForTesting
    static void setIndexSpecDefaults(@Nullable IndexSpec indexSpec) {
        if (indexSpec != null) {
            DEFAULT_INDEX_SPEC = indexSpec;
        }
    }

    private static void setNestedColumnDefaults(DefaultColumnFormatConfig formatsConfig) {
        if (formatsConfig.getNestedColumnFormatVersion() == null || formatsConfig.getNestedColumnFormatVersion() == 5) {
            DimensionHandlerUtils.registerDimensionHandlerProvider("json", new NestedCommonFormatHandlerProvider());
        }
    }

    public static class SideEffectRegisterer {
    }

    public static class NestedCommonFormatHandlerProvider
    implements DimensionHandlerProvider<StructuredData, StructuredData, StructuredData> {
        @Override
        public DimensionHandler<StructuredData, StructuredData, StructuredData> get(String dimensionName) {
            return new NestedCommonFormatColumnHandler(dimensionName, null, IndexSpec.getDefault().getAutoColumnFormatSpec());
        }
    }
}

