/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.druid.java.util.common.HumanReadableBytesSerializer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;

@JsonSerialize(using=HumanReadableBytesSerializer.class)
public class HumanReadableBytes {
    public static final HumanReadableBytes ZERO = new HumanReadableBytes(0L);
    private final long bytes;

    public HumanReadableBytes(String bytes) {
        this.bytes = HumanReadableBytes.parse(bytes);
    }

    public HumanReadableBytes(long bytes) {
        this.bytes = bytes;
    }

    public long getBytes() {
        return this.bytes;
    }

    public int getBytesInInt() {
        if (this.bytes > Integer.MAX_VALUE) {
            throw new ISE("Number [%d] exceeds range of Integer.MAX_VALUE", this.bytes);
        }
        return (int)this.bytes;
    }

    public boolean equals(Object thatObj) {
        if (thatObj == null) {
            return false;
        }
        if (thatObj instanceof HumanReadableBytes) {
            return this.bytes == ((HumanReadableBytes)thatObj).bytes;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    public String toString() {
        return String.valueOf(this.bytes);
    }

    public static HumanReadableBytes valueOf(int bytes) {
        return new HumanReadableBytes(bytes);
    }

    public static HumanReadableBytes valueOf(long bytes) {
        return new HumanReadableBytes(bytes);
    }

    public static long parse(String number) {
        if (number == null) {
            throw new IAE("Invalid format of number: number is null", new Object[0]);
        }
        if ((number = number.trim()).length() == 0) {
            throw new IAE("Invalid format of number: number is blank", new Object[0]);
        }
        return HumanReadableBytes.parseInner(number);
    }

    public static long parse(String number, long nullValue) {
        if (number == null) {
            return nullValue;
        }
        if ((number = number.trim()).length() == 0) {
            return nullValue;
        }
        return HumanReadableBytes.parseInner(number);
    }

    private static long parseInner(String rawNumber) {
        char unit;
        String number = StringUtils.toLowerCase(rawNumber);
        if (number.charAt(0) == '-') {
            throw new IAE("Invalid format of number: %s. Negative value is not allowed.", rawNumber);
        }
        int lastDigitIndex = number.length() - 1;
        boolean isBinaryByte = false;
        if ((unit = number.charAt(lastDigitIndex--)) == 'b') {
            if (lastDigitIndex < 2) {
                throw new IAE("Invalid format of number: %s", rawNumber);
            }
            if (number.charAt(lastDigitIndex--) != 'i') {
                throw new IAE("Invalid format of number: %s", rawNumber);
            }
            unit = number.charAt(lastDigitIndex--);
            isBinaryByte = true;
        } else if (unit == 'i') {
            if (lastDigitIndex < 1) {
                throw new IAE("Invalid format of number [%s]. The unit should be one of Pi/Ti/Gi/Mi/Ki", rawNumber);
            }
            unit = number.charAt(lastDigitIndex--);
            isBinaryByte = true;
        }
        long base = 1L;
        switch (unit) {
            case 'k': {
                base = isBinaryByte ? 1024L : 1000L;
                break;
            }
            case 'm': {
                base = isBinaryByte ? 0x100000L : 1000000L;
                break;
            }
            case 'g': {
                base = isBinaryByte ? 0x40000000L : 1000000000L;
                break;
            }
            case 't': {
                base = isBinaryByte ? 0x10000000000L : 1000000000000L;
                break;
            }
            case 'p': {
                base = isBinaryByte ? 0x4000000000000L : 1000000000000000L;
                break;
            }
            default: {
                if (!Character.isDigit(unit)) {
                    throw new IAE("Invalid format of number: %s", rawNumber);
                }
                ++lastDigitIndex;
            }
        }
        try {
            long value = Long.parseLong(number.substring(0, lastDigitIndex + 1)) * base;
            if (base > 1L && value < base) {
                throw new IAE("Number overflow: %s", rawNumber);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IAE("Invalid format or out of range of long: %s", rawNumber);
        }
    }

    public static String format(long bytes, long precision, UnitSystem unitSystem) {
        if (precision < 0L || precision > 3L) {
            throw new IAE("precision [%d] must be in the range of [0,3]", precision);
        }
        String pattern = "%." + precision + "f %s%s";
        switch (unitSystem.ordinal()) {
            case 0: {
                return BinaryFormatter.format(bytes, pattern, "B");
            }
            case 1: {
                return DecimalFormatter.format(bytes, pattern, "B");
            }
            case 2: {
                return DecimalFormatter.format(bytes, pattern, "").trim();
            }
        }
        throw new IAE("Unkonwn unit system[%s]", new Object[]{unitSystem});
    }

    public static enum UnitSystem {
        BINARY_BYTE,
        DECIMAL_BYTE,
        DECIMAL;

    }

    static class BinaryFormatter {
        private static final String[] UNITS = new String[]{"", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei"};

        BinaryFormatter() {
        }

        static String format(long bytes, String pattern, String suffix) {
            if (bytes > -1024L && bytes < 1024L) {
                return bytes + " " + suffix;
            }
            if (bytes == Long.MIN_VALUE) {
                return StringUtils.format(pattern, -8.0, UNITS[UNITS.length - 1], suffix);
            }
            int unitIndex = (63 - Long.numberOfLeadingZeros(Math.abs(bytes))) / 10;
            return StringUtils.format(pattern, (double)bytes / (double)(1L << unitIndex * 10), UNITS[unitIndex], suffix);
        }
    }

    static class DecimalFormatter {
        private static final String[] UNITS = new String[]{"K", "M", "G", "T", "P", "E"};

        DecimalFormatter() {
        }

        static String format(long bytes, String pattern, String suffix) {
            if (bytes > -1000L && bytes < 1000L) {
                return bytes + " " + suffix;
            }
            int unitIndex = 0;
            while (bytes <= -1000000L || bytes >= 1000000L) {
                bytes /= 1000L;
                ++unitIndex;
            }
            return StringUtils.format(pattern, (double)bytes / 1000.0, UNITS[unitIndex], suffix);
        }
    }
}

