/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.firstlast.FirstLastVectorAggregator;
import org.apache.druid.query.aggregation.firstlast.SelectionPredicate;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class SingleStringFirstLastDimensionVectorAggregator
extends FirstLastVectorAggregator<String, SerializablePairLongString> {
    private final SingleValueDimensionVectorSelector singleValueDimensionVectorSelector;
    private final int maxStringBytes;
    private final SelectionPredicate selectionPredicate;

    protected SingleStringFirstLastDimensionVectorAggregator(VectorValueSelector timeSelector, SingleValueDimensionVectorSelector singleValueDimensionVectorSelector, int maxStringBytes, SelectionPredicate selectionPredicate) {
        super(timeSelector, new SingleValueDimensionVectorSelectorAdapter(singleValueDimensionVectorSelector), null, selectionPredicate);
        this.singleValueDimensionVectorSelector = singleValueDimensionVectorSelector;
        this.maxStringBytes = maxStringBytes;
        this.selectionPredicate = selectionPredicate;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, this.selectionPredicate.initValue());
        buf.put(position + 8, (byte)1);
        buf.putInt(position + 9, 0);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        long time = buf.getLong(position);
        if (buf.get(position + 8) == 1) {
            return new SerializablePairLongString(time, null);
        }
        int index = buf.getInt(position + 9);
        String value = this.singleValueDimensionVectorSelector.lookupName(index);
        return new SerializablePairLongString(time, StringUtils.chop(value, this.maxStringBytes));
    }

    @Override
    protected void putValue(ByteBuffer buf, int position, long time, String value) {
        throw DruidException.defensive("This method is not applicable to the SingleStringFirstLastDimensionVectorAggregator", new Object[0]);
    }

    @Override
    protected void putValue(ByteBuffer buf, int position, long time, VectorValueSelector valueSelector, int index) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        buf.putInt(position + 9, ((SingleValueDimensionVectorSelectorAdapter)valueSelector).singleValueDimensionVectorSelector.getRowVector()[index]);
    }

    @Override
    protected void putNull(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)1);
        buf.putInt(position + 9, 0);
    }

    @Override
    protected SerializablePairLongString readPairFromVectorSelectors(boolean[] timeNullityVector, long[] timeVector, Object[] maybeFoldedObjects, int index) {
        throw DruidException.defensive("This method is not applicable to the SingleStringFirstLastDimensionVectorAggregator", new Object[0]);
    }

    private static class SingleValueDimensionVectorSelectorAdapter
    implements VectorValueSelector {
        private final SingleValueDimensionVectorSelector singleValueDimensionVectorSelector;

        public SingleValueDimensionVectorSelectorAdapter(SingleValueDimensionVectorSelector singleValueDimensionVectorSelector) {
            this.singleValueDimensionVectorSelector = singleValueDimensionVectorSelector;
        }

        @Override
        public int getMaxVectorSize() {
            throw DruidException.defensive("Unexpected call", new Object[0]);
        }

        @Override
        public int getCurrentVectorSize() {
            throw DruidException.defensive("Unexpected call", new Object[0]);
        }

        @Override
        public long[] getLongVector() {
            throw DruidException.defensive("Unexpected call", new Object[0]);
        }

        @Override
        public float[] getFloatVector() {
            throw DruidException.defensive("Unexpected call", new Object[0]);
        }

        @Override
        public double[] getDoubleVector() {
            throw DruidException.defensive("Unexpected call", new Object[0]);
        }

        @Override
        @Nullable
        public boolean[] getNullVector() {
            return null;
        }
    }
}

