/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateMatch;

public interface DruidObjectPredicate<T> {
    public static <T> DruidObjectPredicate<T> alwaysFalseWithNullUnknown() {
        return value -> value == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.FALSE;
    }

    public static <T> DruidObjectPredicate<T> alwaysTrue() {
        return value -> DruidPredicateMatch.TRUE;
    }

    public static <T> DruidObjectPredicate<T> equalTo(T val) {
        return value -> {
            if (value == null) {
                return DruidPredicateMatch.UNKNOWN;
            }
            return DruidPredicateMatch.of(val.equals(value));
        };
    }

    public static <T> DruidObjectPredicate<T> notEqualTo(T val) {
        return value -> {
            if (value == null) {
                return DruidPredicateMatch.UNKNOWN;
            }
            return DruidPredicateMatch.of(!val.equals(value));
        };
    }

    public static <T> DruidObjectPredicate<T> isNull() {
        return value -> DruidPredicateMatch.of(value == null);
    }

    public static <T> DruidObjectPredicate<T> notNull() {
        return value -> DruidPredicateMatch.of(value != null);
    }

    public DruidPredicateMatch apply(@Nullable T var1);
}

