/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.query.operator.AbstractPartitioningOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;

public class NaivePartitioningOperator
extends AbstractPartitioningOperator {
    public NaivePartitioningOperator(List<String> partitionColumns, Operator child) {
        super(partitionColumns, child);
    }

    @Override
    protected AbstractPartitioningOperator.HandleContinuationResult handleContinuation(Operator.Receiver receiver, AbstractPartitioningOperator.Continuation cont) {
        while (cont.iter.hasNext()) {
            Operator.Signal signal = receiver.push(cont.iter.next());
            if (signal == Operator.Signal.GO) continue;
            return this.handleNonGoCases(signal, cont.iter, receiver, cont);
        }
        return AbstractPartitioningOperator.HandleContinuationResult.CONTINUE_PROCESSING;
    }

    @Override
    protected Operator.Receiver createReceiver(Operator.Receiver delegate, AtomicReference<Iterator<RowsAndColumns>> iterHolder) {
        return new NaiveReceiver(delegate, iterHolder, this.partitionColumns);
    }

    private static class NaiveReceiver
    extends AbstractPartitioningOperator.AbstractReceiver {
        public NaiveReceiver(Operator.Receiver delegate, AtomicReference<Iterator<RowsAndColumns>> iterHolder, List<String> partitionColumns) {
            super(delegate, iterHolder, partitionColumns);
        }

        @Override
        protected Iterator<RowsAndColumns> getIteratorForRAC(RowsAndColumns rac) {
            ClusteredGroupPartitioner groupPartitioner = ClusteredGroupPartitioner.fromRAC(rac);
            return groupPartitioner.partitionOnBoundaries(this.partitionColumns).iterator();
        }
    }
}

