/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.ObjectBasedColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;

public class DefaultFramedOnHeapAggregatable
implements FramedOnHeapAggregatable {
    private final AppendableRowsAndColumns rac;

    public DefaultFramedOnHeapAggregatable(AppendableRowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    @Nonnull
    public RowsAndColumns aggregateAll(WindowFrame frame, AggregatorFactory[] aggFactories) {
        Iterable<AggInterval> groupIterator = DefaultFramedOnHeapAggregatable.buildIteratorFor(this.rac, frame);
        ResultPopulator resultRac = new ResultPopulator(aggFactories, this.rac.numRows());
        AggIntervalCursor aggCursor = new AggIntervalCursor(this.rac, aggFactories);
        for (AggInterval aggInterval : groupIterator) {
            aggCursor.moveTo(aggInterval.inputRows);
            resultRac.write(aggInterval.outputRows, aggCursor);
        }
        resultRac.appendTo(this.rac);
        return this.rac;
    }

    public static Iterable<AggInterval> buildIteratorFor(AppendableRowsAndColumns rac, WindowFrame frame) {
        int numRows = rac.numRows();
        if (DefaultFramedOnHeapAggregatable.isEffectivelyUnbounded(frame, numRows)) {
            return DefaultFramedOnHeapAggregatable.buildUnboundedIteratorFor(rac);
        }
        WindowFrame.Rows rowsFrame = frame.unwrap(WindowFrame.Rows.class);
        if (rowsFrame != null) {
            return DefaultFramedOnHeapAggregatable.buildRowIteratorFor(rac, rowsFrame);
        }
        WindowFrame.Groups groupsFrame = frame.unwrap(WindowFrame.Groups.class);
        if (groupsFrame != null) {
            return DefaultFramedOnHeapAggregatable.buildGroupIteratorFor(rac, groupsFrame);
        }
        throw DruidException.defensive("Unable to handle WindowFrame [%s]!", frame);
    }

    private static boolean isEffectivelyUnbounded(WindowFrame frame, int numRows) {
        WindowFrame.OffsetFrame offsetFrame = frame.unwrap(WindowFrame.OffsetFrame.class);
        return offsetFrame.getLowerOffsetClamped(numRows) == -numRows && offsetFrame.getUpperOffsetClamped(numRows) == numRows;
    }

    private static Iterable<AggInterval> buildUnboundedIteratorFor(AppendableRowsAndColumns rac) {
        int[] groupBoundaries = new int[]{0, rac.numRows()};
        return new GroupIteratorForWindowFrame(WindowFrame.rows(null, null), groupBoundaries);
    }

    private static Iterable<AggInterval> buildRowIteratorFor(AppendableRowsAndColumns rac, WindowFrame.Rows frame) {
        int[] groupBoundaries = new int[rac.numRows() + 1];
        for (int j = 0; j < groupBoundaries.length; ++j) {
            groupBoundaries[j] = j;
        }
        return new GroupIteratorForWindowFrame(frame, groupBoundaries);
    }

    private static Iterable<AggInterval> buildGroupIteratorFor(AppendableRowsAndColumns rac, WindowFrame.Groups frame) {
        int[] groupBoundaries = ClusteredGroupPartitioner.fromRAC(rac).computeBoundaries(frame.getOrderByColumns());
        return new GroupIteratorForWindowFrame(frame, groupBoundaries);
    }

    @VisibleForTesting
    public static int invertedOrderForLastK(int x, int n, int k) {
        Preconditions.checkState((k <= n ? 1 : 0) != 0);
        if (k <= 1 || x + k < n) {
            return x;
        }
        int i = x - (n - k);
        return n - 1 - i;
    }

    public static Object cloneAggValue(AggregatorFactory aggFactory, Object value) {
        if (value == null || value instanceof Number) {
            return value;
        }
        Object[] currentValue = new Object[]{value};
        CumulativeColumnSelectorFactory combiningFactory = new CumulativeColumnSelectorFactory(aggFactory, currentValue, 0);
        try (Aggregator combiningAgg = aggFactory.getCombiningFactory().factorize(combiningFactory);){
            combiningAgg.aggregate();
            Object object = aggFactory.finalizeComputation(combiningAgg.get());
            return object;
        }
    }

    static class ResultPopulator {
        private final Object[][] results;
        private final AggregatorFactory[] aggFactories;

        public ResultPopulator(AggregatorFactory[] aggFactories, int numRows) {
            this.aggFactories = aggFactories;
            this.results = new Object[aggFactories.length][numRows];
        }

        public void write(Interval outputRows, AggIntervalCursor aggCursor) {
            for (int col = 0; col < this.aggFactories.length; ++col) {
                Arrays.fill(this.results[col], outputRows.a, outputRows.b, aggCursor.getValue(col));
            }
        }

        public void appendTo(AppendableRowsAndColumns rac) {
            for (int i = 0; i < this.aggFactories.length; ++i) {
                rac.addColumn(this.aggFactories[i].getName(), new ObjectArrayColumn(this.results[i], this.aggFactories[i].getIntermediateType()));
            }
        }
    }

    static class AggIntervalCursor {
        private AggregatorFactory[] aggFactories;
        private final AtomicInteger rowIdProvider;
        private final ColumnSelectorFactory columnSelectorFactory;
        private Interval currentRows = new Interval(0, 0);
        private final Aggregator[] aggregators;

        AggIntervalCursor(AppendableRowsAndColumns rac, AggregatorFactory[] aggFactories) {
            this.aggFactories = aggFactories;
            this.aggregators = new Aggregator[aggFactories.length];
            this.rowIdProvider = new AtomicInteger(0);
            this.columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(rac).make(this.rowIdProvider);
            this.newAggregators();
        }

        public Object getValue(int aggIdx) {
            return DefaultFramedOnHeapAggregatable.cloneAggValue(this.aggFactories[aggIdx], this.aggregators[aggIdx].get());
        }

        public void moveTo(Interval newRows) {
            if (this.currentRows.a == newRows.a && this.currentRows.b < newRows.b) {
                for (int i = this.currentRows.b; i < newRows.b; ++i) {
                    this.aggregate(i);
                }
            } else if (this.currentRows.a > newRows.a && this.currentRows.b == newRows.b) {
                for (int i = newRows.a; i < this.currentRows.a; ++i) {
                    this.aggregate(i);
                }
            } else {
                this.newAggregators();
                for (int i : newRows) {
                    this.aggregate(i);
                }
            }
            this.currentRows = newRows;
        }

        private void newAggregators() {
            for (int i = 0; i < this.aggFactories.length; ++i) {
                this.aggregators[i] = this.aggFactories[i].factorize(this.columnSelectorFactory);
            }
        }

        private void aggregate(int rowIdx) {
            this.rowIdProvider.set(rowIdx);
            for (int i = 0; i < this.aggFactories.length; ++i) {
                this.aggregators[i].aggregate();
            }
        }
    }

    static class AggInterval {
        final Interval outputRows;
        final Interval inputRows;

        public AggInterval(Interval outputRows, Interval inputRows) {
            this.outputRows = outputRows;
            this.inputRows = inputRows;
        }
    }

    static class Interval
    implements Iterable<Integer> {
        final int a;
        final int b;

        public static Interval of(int a, int b) {
            return new Interval(a, b);
        }

        public Interval(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                int current;
                {
                    this.current = a;
                }

                @Override
                public Integer next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    return this.current++;
                }

                @Override
                public boolean hasNext() {
                    return this.current < b;
                }
            };
        }

        public String toString() {
            return StringUtils.format("Interval [%d ... %d[", this.a, this.b);
        }
    }

    static class GroupIteratorForWindowFrame
    implements Iterable<AggInterval> {
        private final int[] groupBoundaries;
        private final int numGroups;
        private final int lowerOffset;
        private final int upperOffset;

        public GroupIteratorForWindowFrame(WindowFrame.OffsetFrame frame, int[] groupBoundaries) {
            this.groupBoundaries = groupBoundaries;
            this.numGroups = groupBoundaries.length - 1;
            this.lowerOffset = frame.getLowerOffsetClamped(this.numGroups);
            this.upperOffset = Math.min(this.numGroups, frame.getUpperOffsetClamped(this.numGroups) + 1);
        }

        @Override
        public Iterator<AggInterval> iterator() {
            return new Iterator<AggInterval>(){
                int currentGroupIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.currentGroupIndex < numGroups;
                }

                @Override
                public AggInterval next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    AggInterval r = new AggInterval(Interval.of(this.groupToRowIndex(this.relativeGroupId(0)), this.groupToRowIndex(this.relativeGroupId(1))), Interval.of(this.groupToRowIndex(this.relativeGroupId(lowerOffset)), this.groupToRowIndex(this.relativeGroupId(upperOffset))));
                    ++this.currentGroupIndex;
                    return r;
                }

                private int groupToRowIndex(int groupId) {
                    return groupBoundaries[groupId];
                }

                private int relativeGroupId(int groupOffset) {
                    int groupIndex = DefaultFramedOnHeapAggregatable.invertedOrderForLastK(this.currentGroupIndex, numGroups, upperOffset);
                    int groupId = groupIndex + groupOffset;
                    if (groupId < 0) {
                        return 0;
                    }
                    if (groupId >= numGroups) {
                        return numGroups;
                    }
                    return groupId;
                }
            };
        }
    }

    private static class CumulativeColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final ColumnCapabilitiesImpl columnCapabilities;
        private final Object[] results;
        private int index;

        public CumulativeColumnSelectorFactory(AggregatorFactory factory, Object[] results, int initialIndex) {
            this.results = results;
            this.index = initialIndex;
            this.columnCapabilities = new ColumnCapabilitiesImpl().setHasBitmapIndexes(false).setDictionaryEncoded(false).setHasMultipleValues(false).setDictionaryValuesUnique(false).setType(factory.getIntermediateType());
        }

        @Override
        @Nonnull
        public DimensionSelector makeDimensionSelector(@Nonnull DimensionSpec dimensionSpec) {
            throw new UOE("combining factory shouldn't need dimensions, just columnValue, dim[%s]", dimensionSpec);
        }

        @Override
        @Nonnull
        public ColumnValueSelector makeColumnValueSelector(@Nonnull String columnName) {
            return new ObjectBasedColumnSelector(){

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Override
                @Nullable
                public Object getObject() {
                    return results[index];
                }

                @Override
                @Nonnull
                public Class classOfObject() {
                    return results[index].getClass();
                }
            };
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(@Nonnull String column) {
            return this.columnCapabilities;
        }
    }
}

