/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.SimpleDoubleBufferAggregator;
import org.apache.druid.query.topn.Historical1AggPooledTopNScanner;
import org.apache.druid.query.topn.TopNUtils;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.historical.HistoricalColumnSelector;
import org.apache.druid.segment.historical.HistoricalCursor;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;

public class Historical1SimpleDoubleAggPooledTopNScannerPrototype
implements Historical1AggPooledTopNScanner<HistoricalDimensionSelector, HistoricalColumnSelector, SimpleDoubleBufferAggregator> {
    @Override
    public long scanAndAggregate(HistoricalDimensionSelector dimensionSelector, HistoricalColumnSelector metricSelector, SimpleDoubleBufferAggregator aggregator, int aggregatorSize, HistoricalCursor cursor, int[] positions, ByteBuffer resultsBuffer) {
        Offset offset = (Offset)TopNUtils.copyOffset(cursor);
        long processedRows = 0L;
        int positionToAllocate = 0;
        while (offset.withinBounds() && !Thread.currentThread().isInterrupted()) {
            int rowNum = offset.getOffset();
            double metric = metricSelector.getDouble(rowNum);
            IndexedInts dimValues = dimensionSelector.getRow(rowNum);
            int dimSize = dimValues.size();
            for (int i = 0; i < dimSize; ++i) {
                int dimIndex = dimValues.get(i);
                int position = positions[dimIndex];
                if (position >= 0) {
                    aggregator.aggregate(resultsBuffer, position, metric);
                    continue;
                }
                if (position != -1) continue;
                positions[dimIndex] = positionToAllocate;
                aggregator.putFirst(resultsBuffer, positionToAllocate, metric);
                positionToAllocate += aggregatorSize;
            }
            ++processedRows;
            offset.increment();
        }
        return processedRows;
    }
}

