/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.Comparator;
import java.util.List;

public class ComparatorSortedDimensionDictionary<T> {
    private final List<T> sortedVals;
    private final int[] idToIndex;
    private final int[] indexToId;

    public ComparatorSortedDimensionDictionary(List<T> idToValue, Comparator<T> comparator, int length) {
        Object2IntRBTreeMap sortedMap = new Object2IntRBTreeMap(comparator);
        for (int id = 0; id < length; ++id) {
            T value = idToValue.get(id);
            sortedMap.put(value, id);
        }
        this.sortedVals = Lists.newArrayList((Iterable)sortedMap.keySet());
        this.idToIndex = new int[length];
        this.indexToId = new int[length];
        int index = 0;
        IntIterator iterator = sortedMap.values().iterator();
        while (iterator.hasNext()) {
            int id = iterator.nextInt();
            this.idToIndex[id] = index;
            this.indexToId[index] = id;
            ++index;
        }
    }

    public int getUnsortedIdFromSortedId(int index) {
        return this.indexToId[index];
    }

    public int getSortedIdFromUnsortedId(int id) {
        return this.idToIndex[id];
    }

    public T getValueFromSortedId(int index) {
        return this.sortedVals.get(index);
    }
}

