/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.VSizeLongSerde;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class DeltaLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final long base;
    private VSizeLongSerde.LongSerializer serializer;
    private int bitsPerValue;

    public DeltaLongEncodingWriter(long base, long delta) {
        this.base = base;
        this.bitsPerValue = VSizeLongSerde.getBitsForMax(delta + 1L);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setOutputStream(WriteOutBytes output) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, output);
    }

    @Override
    public void write(long value) throws IOException {
        this.serializer.write(value - this.base);
    }

    @Override
    public void putMeta(ByteBuffer metaOut, CompressionStrategy strategy) {
        metaOut.put(CompressionFactory.setEncodingFlag(strategy.getId()));
        metaOut.put(CompressionFactory.LongEncodingFormat.DELTA.getId());
        metaOut.put((byte)1);
        metaOut.putLong(this.base);
        metaOut.putInt(this.bitsPerValue);
    }

    @Override
    public int metaSize() {
        return 15;
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return VSizeLongSerde.getNumValuesPerBlock(this.bitsPerValue, bytesPerBlock);
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }

    @Override
    public void flush() throws IOException {
        if (this.serializer != null) {
            this.serializer.close();
        }
    }
}

