/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.SimpleBitmapColumnIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.Utf8ValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.index.semantic.ValueSetIndexes;

public final class IndexedUtf8ValueIndexes<TDictionary extends Indexed<ByteBuffer>>
implements StringValueSetIndexes,
Utf8ValueSetIndexes,
ValueIndexes,
ValueSetIndexes {
    private static final double SORTED_MERGE_RATIO_THRESHOLD = 0.12;
    private static final int SIZE_WORTH_CHECKING_MIN = 8;
    private static final Comparator<ByteBuffer> COMPARATOR = ByteBufferUtils.utf8Comparator();
    private final BitmapFactory bitmapFactory;
    private final TDictionary dictionary;
    private final Indexed<ImmutableBitmap> bitmaps;

    public IndexedUtf8ValueIndexes(BitmapFactory bitmapFactory, TDictionary dictionary, Indexed<ImmutableBitmap> bitmaps) {
        Preconditions.checkArgument((boolean)dictionary.isSorted(), (Object)"Dictionary must be sorted");
        this.bitmapFactory = bitmapFactory;
        this.dictionary = dictionary;
        this.bitmaps = bitmaps;
    }

    @Override
    public BitmapColumnIndex forValue(@Nullable String value) {
        final ByteBuffer utf8 = StringUtils.toUtf8ByteBuffer(value);
        return new SimpleBitmapColumnIndex(){

            @Override
            public int estimatedComputeCost() {
                return 1;
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                if (includeUnknown && IndexedUtf8ValueIndexes.this.dictionary.get(0) == null) {
                    return bitmapResultFactory.unionDimensionValueBitmaps((Iterable<ImmutableBitmap>)ImmutableList.of((Object)this.getBitmapForValue(), (Object)IndexedUtf8ValueIndexes.this.getBitmap(0)));
                }
                return bitmapResultFactory.wrapDimensionValue(this.getBitmapForValue());
            }

            private ImmutableBitmap getBitmapForValue() {
                int idx = IndexedUtf8ValueIndexes.this.dictionary.indexOf((ByteBuffer)utf8);
                return IndexedUtf8ValueIndexes.this.getBitmap(idx);
            }
        };
    }

    @Override
    @Nullable
    public BitmapColumnIndex forValue(@Nonnull Object value, TypeSignature<ValueType> valueType) {
        if (valueType.isPrimitive()) {
            return this.forValue(ExprEval.ofType(ExpressionType.fromColumnTypeStrict(valueType), value).castTo(ExpressionType.STRING).asString());
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public BitmapColumnIndex forSortedValues(SortedSet<String> values) {
        return this.getBitmapColumnIndexForSortedIterableUtf8(Iterables.transform(values, StringUtils::toUtf8ByteBuffer), values.size(), values.contains(null));
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public BitmapColumnIndex forSortedValuesUtf8(List<ByteBuffer> sortedValuesUtf8) {
        ByteBuffer minValueInColumn;
        int position;
        boolean matchNull;
        if (sortedValuesUtf8.isEmpty()) {
            return new AllFalseBitmapColumnIndex(this.bitmapFactory);
        }
        boolean bl = matchNull = sortedValuesUtf8.get(0) == null;
        List<ByteBuffer> tailSet = sortedValuesUtf8.size() >= 8 ? sortedValuesUtf8.subList((position = Collections.binarySearch(sortedValuesUtf8, minValueInColumn = (ByteBuffer)this.dictionary.get(0), ByteBufferUtils.utf8Comparator())) >= 0 ? position : -(position + 1), sortedValuesUtf8.size()) : sortedValuesUtf8;
        return this.getBitmapColumnIndexForSortedIterableUtf8(tailSet, tailSet.size(), matchNull);
    }

    private ImmutableBitmap getBitmap(int idx) {
        if (idx < 0) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        ImmutableBitmap bitmap = this.bitmaps.get(idx);
        return bitmap == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
    }

    private BitmapColumnIndex getBitmapColumnIndexForSortedIterableUtf8(Iterable<ByteBuffer> valuesUtf8, int size, boolean valuesContainsNull) {
        if ((double)size > 0.12 * (double)this.dictionary.size()) {
            return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorScan(this.bitmapFactory, COMPARATOR, valuesUtf8, size, this.dictionary, this.bitmaps, (Supplier<ImmutableBitmap>)((Supplier)() -> {
                if (!valuesContainsNull && this.dictionary.get(0) == null) {
                    return this.bitmaps.get(0);
                }
                return null;
            }));
        }
        return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorBinarySearch(this.bitmapFactory, valuesUtf8, size, this.dictionary, this.bitmaps, (Supplier<ImmutableBitmap>)((Supplier)() -> {
            if (!valuesContainsNull && this.dictionary.get(0) == null) {
                return this.bitmaps.get(0);
            }
            return null;
        }));
    }

    @Override
    @Nullable
    public BitmapColumnIndex forSortedValues(@Nonnull List<?> sortedValues, TypeSignature<ValueType> matchValueType) {
        if (sortedValues.isEmpty()) {
            return new AllFalseBitmapColumnIndex(this.bitmapFactory);
        }
        boolean matchNull = sortedValues.get(0) == null;
        Supplier unknownsIndex = () -> {
            if (!matchNull && this.dictionary.get(0) == null) {
                return this.bitmaps.get(0);
            }
            return null;
        };
        if (matchValueType.is(ValueType.STRING)) {
            Object minValueInColumn;
            int position;
            List<?> baseSet = sortedValues;
            List<?> tailSet = sortedValues.size() >= 8 ? baseSet.subList((position = Collections.binarySearch(sortedValues, StringUtils.fromUtf8Nullable((ByteBuffer)(minValueInColumn = this.dictionary.get(0))), matchValueType.getNullableStrategy())) >= 0 ? position : -(position + 1), baseSet.size()) : baseSet;
            if ((double)tailSet.size() > 0.12 * (double)this.dictionary.size()) {
                return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorScan(this.bitmapFactory, ByteBufferUtils.utf8Comparator(), Iterables.transform(tailSet, StringUtils::toUtf8ByteBuffer), tailSet.size(), this.dictionary, this.bitmaps, (Supplier<ImmutableBitmap>)unknownsIndex);
            }
            return ValueSetIndexes.buildBitmapColumnIndexFromSortedIteratorBinarySearch(this.bitmapFactory, Iterables.transform(tailSet, StringUtils::toUtf8ByteBuffer), tailSet.size(), this.dictionary, this.bitmaps, (Supplier<ImmutableBitmap>)unknownsIndex);
        }
        return ValueSetIndexes.buildBitmapColumnIndexFromIteratorBinarySearch(this.bitmapFactory, Iterables.transform(sortedValues, x -> StringUtils.toUtf8ByteBuffer(DimensionHandlerUtils.convertObjectToString(x))), sortedValues.size(), this.dictionary, this.bitmaps, (Supplier<ImmutableBitmap>)unknownsIndex);
    }
}

