/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.NoopQueryableIndex;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class TombstoneSegmentizerFactory
implements SegmentizerFactory {
    @Override
    public Segment factorize(DataSegment segment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) {
        return TombstoneSegmentizerFactory.segmentForTombstone(segment);
    }

    @VisibleForTesting
    public static Segment segmentForTombstone(final DataSegment tombstone) {
        Preconditions.checkArgument((boolean)tombstone.isTombstone());
        final NoopQueryableIndex queryableIndex = new NoopQueryableIndex(){

            @Override
            public Interval getDataInterval() {
                return tombstone.getInterval();
            }
        };
        Segment segmentObject = new Segment(){

            @Override
            public SegmentId getId() {
                return tombstone.getId();
            }

            @Override
            public Interval getDataInterval() {
                return tombstone.getInterval();
            }

            @Override
            @Nullable
            public <T> T as(@Nonnull Class<T> clazz) {
                if (CursorFactory.class.equals(clazz)) {
                    return (T)new CursorFactory(){

                        @Override
                        public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
                            return new CursorHolder(){

                                @Override
                                @Nullable
                                public Cursor asCursor() {
                                    return null;
                                }
                            };
                        }

                        @Override
                        public RowSignature getRowSignature() {
                            return RowSignature.empty();
                        }

                        @Override
                        @Nullable
                        public ColumnCapabilities getColumnCapabilities(String column) {
                            return null;
                        }
                    };
                }
                if (QueryableIndex.class.equals(clazz)) {
                    return (T)queryableIndex;
                }
                return null;
            }

            @Override
            public boolean isTombstone() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        return segmentObject;
    }
}

