/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.writeout.FileWriteOutBytes;
import org.apache.druid.segment.writeout.LazilyAllocatingHeapWriteOutBytes;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public final class TmpFileSegmentWriteOutMedium
implements SegmentWriteOutMedium {
    private static final Logger log = new Logger(TmpFileSegmentWriteOutMedium.class);
    private final AtomicInteger filesCreated;
    private final SortedMap<Long, Integer> sizeDistribution;
    private int numLocallyCreated = 0;
    private boolean root = false;
    private final File dir;
    private final Closer closer = Closer.create();

    TmpFileSegmentWriteOutMedium(File outDir) throws IOException {
        this(outDir, new AtomicInteger(0), new ConcurrentSkipListMap<Long, Integer>());
        this.root = true;
    }

    private TmpFileSegmentWriteOutMedium(File outDir, AtomicInteger filesCreated, SortedMap<Long, Integer> sizeDistribution) throws IOException {
        this.filesCreated = filesCreated;
        this.sizeDistribution = sizeDistribution;
        File tmpOutputFilesDir = new File(outDir, "tmpOutputFiles");
        FileUtils.mkdirp(tmpOutputFilesDir);
        this.closer.register(() -> FileUtils.deleteDirectory(tmpOutputFilesDir));
        this.dir = tmpOutputFilesDir;
    }

    @Override
    public WriteOutBytes makeWriteOutBytes() {
        return new LazilyAllocatingHeapWriteOutBytes(() -> {
            FileChannel ch;
            File file;
            int i = this.filesCreated.incrementAndGet();
            ++this.numLocallyCreated;
            try {
                file = File.createTempFile("filePeon", null, this.dir);
                ch = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                throw DruidException.defensive(e, "Failed", new Object[0]);
            }
            if (i % 1000 == 0) {
                log.info("Created [%,d] tmp files. [%s]", i, this.dir);
            }
            FileWriteOutBytes retVal = new FileWriteOutBytes(file, ch, this.closer);
            this.closer.register(file::delete);
            this.closer.register(ch);
            this.closer.register(() -> this.sizeDistribution.compute(retVal.size(), (key, val) -> val == null ? 1 : val + 1));
            return retVal;
        }, this.closer);
    }

    @Override
    public SegmentWriteOutMedium makeChildWriteOutMedium() throws IOException {
        TmpFileSegmentWriteOutMedium tmpFileSegmentWriteOutMedium = new TmpFileSegmentWriteOutMedium(this.dir, this.filesCreated, this.sizeDistribution);
        this.closer.register(tmpFileSegmentWriteOutMedium);
        return tmpFileSegmentWriteOutMedium;
    }

    @Override
    public Closer getCloser() {
        return this.closer;
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing, files still open[%,d], filesBeingClosed[%,d], dir[%s]", this.filesCreated.get(), this.numLocallyCreated, this.dir);
        this.filesCreated.set(this.filesCreated.get() - this.numLocallyCreated);
        this.numLocallyCreated = 0;
        this.closer.close();
        if (this.root && log.isDebugEnabled()) {
            log.debug("Size distribution of files:", new Object[0]);
            for (Map.Entry<Long, Integer> entry : this.sizeDistribution.entrySet()) {
                log.debug("%,15d => %,15d", entry.getKey(), entry.getValue());
            }
        }
    }

    @VisibleForTesting
    int getFilesCreated() {
        return this.filesCreated.get();
    }

    @VisibleForTesting
    int getNumLocallyCreated() {
        return this.numLocallyCreated;
    }
}

