/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.server.lookup.DataFetcher;
import org.apache.druid.server.lookup.LookupExtractionModule;
import org.apache.druid.server.lookup.cache.loading.LoadingCache;

public class LoadingLookup
extends LookupExtractor {
    private static final Logger LOGGER = new Logger(LoadingLookup.class);
    private final DataFetcher<String, String> dataFetcher;
    private final LoadingCache<String, String> loadingCache;
    private final LoadingCache<String, List<String>> reverseLoadingCache;
    private final AtomicBoolean isOpen;
    private final String id = Integer.toHexString(System.identityHashCode((Object)this));

    public LoadingLookup(DataFetcher dataFetcher, LoadingCache<String, String> loadingCache, LoadingCache<String, List<String>> reverseLoadingCache) {
        this.dataFetcher = (DataFetcher)Preconditions.checkNotNull((Object)dataFetcher, (Object)"lookup must have a DataFetcher");
        this.loadingCache = (LoadingCache)Preconditions.checkNotNull(loadingCache, (Object)"loading lookup need a cache");
        this.reverseLoadingCache = (LoadingCache)Preconditions.checkNotNull(reverseLoadingCache, (Object)"loading lookup need reverse cache");
        this.isOpen = new AtomicBoolean(true);
    }

    public String apply(@Nullable String key) {
        if (key == null) {
            return null;
        }
        String presentVal = this.loadingCache.getIfPresent(key);
        if (presentVal != null) {
            return presentVal;
        }
        String val = this.dataFetcher.fetch(key);
        if (val == null) {
            return null;
        }
        this.loadingCache.putAll(Collections.singletonMap(key, val));
        return val;
    }

    public List<String> unapply(@Nullable String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        try {
            List<String> retList = this.reverseLoadingCache.get(value, new UnapplyCallable(value));
            return retList;
        }
        catch (ExecutionException e) {
            LOGGER.debug("list of keys not found for value [%s]", new Object[]{value});
            return Collections.emptyList();
        }
    }

    public boolean supportsAsMap() {
        return true;
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Optional.ofNullable(this.dataFetcher.fetchAll()).ifPresent(data -> data.forEach(entry -> map.put((String)entry.getKey(), (String)entry.getValue())));
        return map;
    }

    public byte[] getCacheKey() {
        return LookupExtractionModule.getRandomCacheKey();
    }

    public synchronized void close() {
        if (this.isOpen.getAndSet(false)) {
            LOGGER.info("Closing loading cache [%s]", new Object[]{this.id});
            this.loadingCache.close();
            this.reverseLoadingCache.close();
        } else {
            LOGGER.info("Closing already closed lookup", new Object[0]);
        }
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public String toString() {
        return "LoadingLookup{dataFetcher=" + String.valueOf(this.dataFetcher) + ", id='" + this.id + "'}";
    }

    private class UnapplyCallable
    implements Callable<List<String>> {
        private final String value;

        public UnapplyCallable(String value) {
            this.value = value;
        }

        @Override
        public List<String> call() {
            return LoadingLookup.this.dataFetcher.reverseFetchKeys(this.value);
        }
    }
}

