/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.spnego;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamePasswordCallbackHandler
implements CallbackHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PASSWORD_CALLBACK_NAME = "setObject";
    private static final Class<?>[] PASSWORD_CALLBACK_TYPES = new Class[]{Object.class, char[].class, String.class};
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String passwordCallbackName;

    public NamePasswordCallbackHandler(String username, @Nullable String password) {
        this(username, password, null);
    }

    public NamePasswordCallbackHandler(String username, @Nullable String password, @Nullable String passwordCallbackName) {
        this.username = username;
        this.password = password;
        this.passwordCallbackName = passwordCallbackName;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (this.handleCallback(callback)) continue;
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pwCallback = (PasswordCallback)callback;
                pwCallback.setPassword(this.password != null ? this.password.toCharArray() : null);
                continue;
            }
            if (this.invokePasswordCallback(callback)) continue;
            String errorMsg = "Unsupported callback type " + callback.getClass().getName();
            this.log.info(errorMsg);
            throw new UnsupportedCallbackException(callback, errorMsg);
        }
    }

    protected boolean handleCallback(Callback callback) {
        return false;
    }

    private boolean invokePasswordCallback(Callback callback) {
        String cbname = this.passwordCallbackName == null ? PASSWORD_CALLBACK_NAME : this.passwordCallbackName;
        for (Class<?> arg : PASSWORD_CALLBACK_TYPES) {
            try {
                Method method = callback.getClass().getMethod(cbname, arg);
                Object[] args = new Object[]{arg == String.class ? this.password : (this.password != null ? (Object)this.password.toCharArray() : null)};
                method.invoke((Object)callback, args);
                return true;
            }
            catch (Exception e) {
                this.log.debug(e.toString());
            }
        }
        return false;
    }
}

