/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.colors;

import com.github.rvesse.airline.io.colors.AnsiColorProvider;

public enum BasicColor implements AnsiColorProvider
{
    BLACK(0, "Black"),
    RED(1, "Red"),
    GREEN(2, "Green"),
    YELLOW(3, "Yellow"),
    BLUE(4, "Blue"),
    MAGENTA(5, "Magenta"),
    CYAN(6, "Cyan"),
    WHITE(7, "White"),
    BRIGHT_BLACK(0, "Black", true),
    BRIGHT_RED(1, "Red", true),
    BRIGHT_GREEN(2, "Green", true),
    BRIGHT_YELLOW(3, "Yellow", true),
    BRIGHT_BLUE(4, "Blue", true),
    BRIGHT_MAGENTA(5, "Magenta", true),
    BRIGHT_CYAN(6, "Cyan", true),
    BRIGHT_WHITE(7, "White", true);

    private final int index;
    private final String name;
    private final boolean highIntensity;

    private BasicColor(int index, String name) {
        this(index, name, false);
    }

    private BasicColor(int index, String name, boolean highIntensity) {
        this.index = index;
        this.name = name;
        this.highIntensity = highIntensity;
    }

    @Override
    public String getAnsiForegroundControlCode() {
        return this.getAnsiControlCode(this.highIntensity ? 90 : 30);
    }

    @Override
    public String getAnsiBackgroundControlCode() {
        return this.getAnsiControlCode(this.highIntensity ? 100 : 40);
    }

    @Override
    public boolean usesExtendedColors() {
        return false;
    }

    private String getAnsiControlCode(int base) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[").append(base + this.index).append('m');
        return builder.toString();
    }

    public String toString() {
        if (this.highIntensity) {
            return String.format("Bright %s", this.name);
        }
        return this.name;
    }
}

