/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.kinesis;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.kinesis.KinesisRecordEntity;
import org.apache.druid.indexing.seekablestream.SettableByteEntity;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.joda.time.DateTime;

public class KinesisInputReader
implements InputEntityReader {
    private final InputRowSchema inputRowSchema;
    private final SettableByteEntity<KinesisRecordEntity> source;
    private final InputEntityReader valueParser;
    private final String partitionKeyColumnName;
    private final String timestampColumnName;

    public KinesisInputReader(InputRowSchema inputRowSchema, SettableByteEntity<KinesisRecordEntity> source, InputEntityReader valueParser, String partitionKeyColumnName, String timestampColumnName) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.valueParser = valueParser;
        this.partitionKeyColumnName = partitionKeyColumnName;
        this.timestampColumnName = timestampColumnName;
    }

    public CloseableIterator<InputRow> read() throws IOException {
        KinesisRecordEntity record = (KinesisRecordEntity)this.source.getEntity();
        Map<String, Object> mergedHeaderMap = this.extractHeaders(record);
        if (record.getRecord().getData() != null) {
            return this.buildBlendedRows(this.valueParser, mergedHeaderMap);
        }
        return CloseableIterators.withEmptyBaggage(this.buildInputRowsForMap(mergedHeaderMap).iterator());
    }

    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        KinesisRecordEntity record = (KinesisRecordEntity)this.source.getEntity();
        InputRowListPlusRawValues headers = this.extractHeaderSample(record);
        if (record.getRecord().getData() != null) {
            return this.buildBlendedRowsSample(this.valueParser, headers.getRawValues());
        }
        List<InputRowListPlusRawValues> rows = Collections.singletonList(headers);
        return CloseableIterators.withEmptyBaggage(rows.iterator());
    }

    private Map<String, Object> extractHeaders(KinesisRecordEntity record) {
        HashMap<String, Object> mergedHeaderMap = new HashMap<String, Object>();
        mergedHeaderMap.put(this.timestampColumnName, record.getRecord().getApproximateArrivalTimestamp().getTime());
        mergedHeaderMap.put(this.partitionKeyColumnName, record.getRecord().getPartitionKey());
        return mergedHeaderMap;
    }

    private CloseableIterator<InputRow> buildBlendedRows(InputEntityReader valueParser, Map<String, Object> headerKeyList) throws IOException {
        return valueParser.read().map(r -> {
            HashSet<String> newDimensions = new HashSet<String>(r.getDimensions());
            Map<String, Object> event = this.buildBlendedEventMap(arg_0 -> ((InputRow)r).getRaw(arg_0), newDimensions, headerKeyList);
            newDimensions.addAll(headerKeyList.keySet());
            newDimensions.remove("__kif_auto_timestamp");
            DateTime timestamp = MapInputRowParser.parseTimestamp((TimestampSpec)this.inputRowSchema.getTimestampSpec(), event);
            return new MapBasedInputRow(timestamp, MapInputRowParser.findDimensions((TimestampSpec)this.inputRowSchema.getTimestampSpec(), (DimensionsSpec)this.inputRowSchema.getDimensionsSpec(), newDimensions), event);
        });
    }

    private InputRowListPlusRawValues extractHeaderSample(KinesisRecordEntity record) {
        Map<String, Object> mergedHeaderMap = this.extractHeaders(record);
        return InputRowListPlusRawValues.of(this.buildInputRowsForMap(mergedHeaderMap), mergedHeaderMap);
    }

    private CloseableIterator<InputRowListPlusRawValues> buildBlendedRowsSample(InputEntityReader valueParser, Map<String, Object> headerKeyList) throws IOException {
        return valueParser.sample().map(rowAndValues -> {
            if (rowAndValues.getParseException() != null) {
                return rowAndValues;
            }
            ArrayList newInputRows = Lists.newArrayListWithCapacity((int)rowAndValues.getInputRows().size());
            ArrayList newRawRows = Lists.newArrayListWithCapacity((int)rowAndValues.getRawValues().size());
            for (Map raw : rowAndValues.getRawValuesList()) {
                newRawRows.add(this.buildBlendedEventMap(raw::get, raw.keySet(), headerKeyList));
            }
            for (InputRow r : rowAndValues.getInputRows()) {
                if (r == null) continue;
                HashSet<String> newDimensions = new HashSet<String>(r.getDimensions());
                Map<String, Object> event = this.buildBlendedEventMap(arg_0 -> ((InputRow)r).getRaw(arg_0), newDimensions, headerKeyList);
                newDimensions.addAll(headerKeyList.keySet());
                newDimensions.remove("__kif_auto_timestamp");
                newInputRows.add(new MapBasedInputRow(this.inputRowSchema.getTimestampSpec().extractTimestamp(event), MapInputRowParser.findDimensions((TimestampSpec)this.inputRowSchema.getTimestampSpec(), (DimensionsSpec)this.inputRowSchema.getDimensionsSpec(), newDimensions), event));
            }
            return InputRowListPlusRawValues.ofList((List)newRawRows, (List)newInputRows, null);
        });
    }

    private List<InputRow> buildInputRowsForMap(Map<String, Object> headerKeyList) {
        return Collections.singletonList(new MapBasedInputRow(this.inputRowSchema.getTimestampSpec().extractTimestamp(headerKeyList), MapInputRowParser.findDimensions((TimestampSpec)this.inputRowSchema.getTimestampSpec(), (DimensionsSpec)this.inputRowSchema.getDimensionsSpec(), headerKeyList.keySet()), headerKeyList));
    }

    private Map<String, Object> buildBlendedEventMap(final Function<String, Object> getRowValue, Set<String> rowDimensions, final Map<String, Object> fallback) {
        final HashSet<String> keySet = new HashSet<String>(fallback.keySet());
        keySet.addAll(rowDimensions);
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                String skey = (String)key;
                Object val = getRowValue.apply(skey);
                if (val == null) {
                    return fallback.get(skey);
                }
                return val;
            }

            @Override
            public Set<String> keySet() {
                return keySet;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.keySet().stream().map(field -> new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        return field;
                    }

                    @Override
                    public Object getValue() {
                        return this.get(field);
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                }).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        };
    }
}

