/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AllowHttpMethodsResourceFilter
implements Filter {
    @VisibleForTesting
    static final List<String> SUPPORTED_METHODS = ImmutableList.of((Object)"GET", (Object)"POST", (Object)"PUT", (Object)"DELETE");
    private final Set<String> supportedMethods;

    public AllowHttpMethodsResourceFilter(@Nonnull List<String> additionalSupportedMethods) {
        this.supportedMethods = Sets.newHashSetWithExpectedSize((int)(additionalSupportedMethods.size() + SUPPORTED_METHODS.size()));
        this.supportedMethods.addAll(SUPPORTED_METHODS);
        this.supportedMethods.addAll(additionalSupportedMethods);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        if (!this.supportedMethods.contains(httpReq.getMethod())) {
            ((HttpServletResponse)response).sendError(405);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

