/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import javax.annotation.Nullable;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;

public class SumSqlAggregator
extends SimpleSqlAggregator {
    private static final SqlAggFunction DRUID_SUM = new SqlSumAggFunction((RelDataType)Nullness.castNonNull(null)){};

    @Override
    public SqlAggFunction calciteFunction() {
        return DRUID_SUM;
    }

    @Override
    @Nullable
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName) {
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (valueType == null) {
            return null;
        }
        return Aggregation.create(SumSqlAggregator.createSumAggregatorFactory(valueType, name, fieldName, macroTable));
    }

    static AggregatorFactory createSumAggregatorFactory(ColumnType aggregationType, String name, String fieldName, ExprMacroTable macroTable) {
        switch ((ValueType)aggregationType.getType()) {
            case LONG: {
                return new LongSumAggregatorFactory(name, fieldName, null, macroTable);
            }
            case FLOAT: {
                return new FloatSumAggregatorFactory(name, fieldName, null, macroTable);
            }
            case DOUBLE: {
                return new DoubleSumAggregatorFactory(name, fieldName, null, macroTable);
            }
        }
        throw SimpleSqlAggregator.badTypeException(fieldName, "SUM", aggregationType);
    }
}

