/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.run;

import java.util.Map;
import java.util.Set;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.sql.calcite.run.EngineFeature;

public class SqlEngines {
    public static void validateNoSpecialContextKeys(Map<String, Object> queryContext, Set<String> specialContextKeys) {
        for (String contextParameterName : queryContext.keySet()) {
            if (!specialContextKeys.contains(contextParameterName)) continue;
            throw InvalidInput.exception((String)"Query context parameter [%s] is not allowed", (Object[])new Object[]{contextParameterName});
        }
    }

    public static DruidException generateUnrecognizedFeatureException(String engineName, EngineFeature unrecognizedFeature) {
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build("Engine [%s] is unable to recognize the feature [%s] for availability. This might happen when a newer feature is added without updating all the implementations of SqlEngine(s) to either allow or disallow its availability. Please raise an issue if you encounter this exception while using Druid.", new Object[]{engineName, unrecognizedFeature});
    }
}

