/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.http.ResultFormat;

public class CsvWriter
implements ResultFormat.Writer {
    private final OutputStream outputStream;
    private final CSVWriter writer;
    private final List<String> currentLine = new ArrayList<String>();

    public CsvWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.writer = new CSVWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
    }

    @Override
    public void writeResponseStart() {
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.writer.flush();
        this.outputStream.write(10);
        this.outputStream.flush();
    }

    @Override
    public void writeHeader(RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) {
        int i;
        RowSignature signature = RowSignatures.fromRelDataType(rowType.getFieldNames(), rowType);
        this.writer.writeNext(signature.getColumnNames().toArray(new String[0]), false);
        if (includeTypes) {
            String[] types = new String[rowType.getFieldCount()];
            for (i = 0; i < signature.size(); ++i) {
                types[i] = signature.getColumnType(i).map(TypeSignature::asTypeString).orElse(null);
            }
            this.writer.writeNext(types, false);
        }
        if (includeSqlTypes) {
            String[] sqlTypes = new String[rowType.getFieldCount()];
            for (i = 0; i < signature.size(); ++i) {
                sqlTypes[i] = ((RelDataTypeField)rowType.getFieldList().get(i)).getType().getSqlTypeName().getName();
            }
            this.writer.writeNext(sqlTypes, false);
        }
    }

    @Override
    public void writeHeaderFromRowSignature(RowSignature signature, boolean includeTypes) {
        this.writer.writeNext(signature.getColumnNames().toArray(new String[0]), false);
        if (includeTypes) {
            String[] types = new String[signature.size()];
            for (int i = 0; i < signature.size(); ++i) {
                types[i] = signature.getColumnType(i).map(TypeSignature::asTypeString).orElse(null);
            }
            this.writer.writeNext(types, false);
        }
    }

    @Override
    public void writeRowStart() {
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) {
        if (value == null) {
            this.currentLine.add("");
        } else if (value instanceof String) {
            this.currentLine.add((String)value);
        } else {
            this.currentLine.add(value.toString());
        }
    }

    @Override
    public void writeRowEnd() {
        boolean quoteEverything = this.currentLine.size() == 1 && this.currentLine.get(0).isEmpty();
        this.writer.writeNext(this.currentLine.toArray(new String[0]), quoteEverything);
        this.currentLine.clear();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

